/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.reconciler;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.core.editor.reconciler.ReplaceRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XtextReconcilerUnitOfWork
extends IUnitOfWork.Void<XtextResource> {
    private static final Logger log = Logger.getLogger(XtextReconcilerUnitOfWork.class);
    private IRegion region;
    private IDocument document;

    public XtextReconcilerUnitOfWork(IRegion region, IDocument document) {
        this.document = document;
        this.region = region;
    }

    public void process(XtextResource resource) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing reconciliation.");
        }
        try {
            if (!(this.region instanceof ReplaceRegion)) {
                throw new IllegalArgumentException("Region to be reconciled must be a ReplaceRegion");
            }
            ReplaceRegion replaceRegionToBeProcessed = (ReplaceRegion)this.region;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Parsing replace region '" + replaceRegionToBeProcessed.getText() + "'."));
            }
            resource.update(replaceRegionToBeProcessed.getOffset(), replaceRegionToBeProcessed.getLength(), replaceRegionToBeProcessed.getText());
            EcoreUtil.resolveAll((Resource)resource);
        }
        catch (Exception t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Partial parsing failed. Performing full reparse", (Throwable)t);
            }
            try {
                resource.reparse(this.document.get());
            }
            catch (Exception e) {
                log.error((Object)"Parsing in reconciler failed.", (Throwable)e);
            }
        }
    }
}

