/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.reconciler;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.core.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.core.editor.reconciler.ReplaceRegion;
import org.eclipse.xtext.ui.core.editor.reconciler.XtextDocumentReconcileStrategy;
import org.eclipse.xtext.ui.core.editor.reconciler.XtextReconcilerUnitOfWork;

public class XtextReconciler
extends Job
implements IReconciler {
    private static final Logger log = Logger.getLogger(XtextReconciler.class);
    private boolean isInstalled;
    private ITextViewer textViewer;
    private TextInputListener textInputListener;
    private final DocumentListener documentListener;
    private ReplaceRegion pendingReplaceRegion;
    private final Object pendingReplaceRegionLock;
    private int delay;
    private IReconcilingStrategy strategy;

    @Inject
    public XtextReconciler(XtextDocumentReconcileStrategy strategy) {
        super("XtextReconcilerJob");
        this.setPriority(20);
        this.setSystem(true);
        this.isInstalled = false;
        this.documentListener = new DocumentListener();
        this.pendingReplaceRegionLock = new Object();
        this.setDelay(500);
        this.setReconcilingStrategy(strategy);
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return this.strategy;
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy) {
        this.strategy = strategy;
    }

    public void install(ITextViewer textViewer) {
        if (!this.isInstalled) {
            this.textViewer = textViewer;
            this.textInputListener = new TextInputListener();
            textViewer.addTextInputListener((ITextInputListener)this.textInputListener);
            this.handleInputDocumentChanged(null, textViewer.getDocument());
            this.isInstalled = true;
        }
    }

    public void uninstall() {
        if (this.isInstalled) {
            this.textViewer.removeTextInputListener((ITextInputListener)this.textInputListener);
            this.isInstalled = false;
        }
    }

    private void handleInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput != null) {
            ((IXtextDocument)oldInput).removeXtextDocumentContentObserver(this.documentListener);
        }
        if (newInput != null) {
            ((IXtextDocument)newInput).addXtextDocumentContentObserver(this.documentListener);
            final IXtextDocument document = XtextDocumentUtil.get(this.textViewer);
            this.strategy.setDocument((IDocument)document);
            document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource resource) throws Exception {
                    block3: {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"XtextReconiler: Reparsing document.");
                            }
                            resource.reparse(document.get());
                        }
                        catch (Throwable t) {
                            if (!log.isDebugEnabled()) break block3;
                            log.debug((Object)"Partial parsing failed. Performing full reparse", t);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentChanged(DocumentEvent event) {
        this.cancel();
        ReplaceRegion newReplaceRegion = new ReplaceRegion(event.getOffset(), event.getLength(), event.getText());
        Object object = this.pendingReplaceRegionLock;
        synchronized (object) {
            if (this.pendingReplaceRegion != null) {
                this.pendingReplaceRegion.mergeWith(newReplaceRegion, event.getDocument());
            } else {
                this.pendingReplaceRegion = newReplaceRegion;
            }
        }
        this.schedule(this.delay);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean belongsTo(Object family) {
        return XtextReconciler.class.getName().equals(family);
    }

    protected IStatus run(IProgressMonitor monitor) {
        ReplaceRegion replaceRegionToBeProcessed;
        IXtextDocument document;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing reconciliation.");
        }
        if ((document = XtextDocumentUtil.get(this.textViewer)) != null && (replaceRegionToBeProcessed = this.getAndResetReplaceRegion()) != null) {
            this.strategy.reconcile((IRegion)replaceRegionToBeProcessed);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reconciliation finished. Time required: " + (System.currentTimeMillis() - start)));
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplaceRegion getAndResetReplaceRegion() {
        ReplaceRegion replaceRegionToBeProcessed;
        Object object = this.pendingReplaceRegionLock;
        synchronized (object) {
            replaceRegionToBeProcessed = this.pendingReplaceRegion != null ? this.pendingReplaceRegion : null;
            this.pendingReplaceRegion = null;
        }
        return replaceRegionToBeProcessed;
    }

    class DocumentListener
    implements IDocumentListener,
    IXtextDocumentContentObserver {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            XtextReconciler.this.handleDocumentChanged(event);
        }

        public void performNecessaryUpdates(IXtextDocumentContentObserver.Processor processor) {
            ReplaceRegion replaceRegionToBeProcessed;
            IXtextDocument document = XtextDocumentUtil.get(XtextReconciler.this.textViewer);
            if (document != null && (replaceRegionToBeProcessed = XtextReconciler.this.getAndResetReplaceRegion()) != null) {
                processor.process(new XtextReconcilerUnitOfWork((IRegion)replaceRegionToBeProcessed, document));
            }
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            XtextReconciler.this.handleInputDocumentChanged(oldInput, newInput);
        }
    }
}

