/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.preferences.fields;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class CheckBoxGroupFieldEditor
extends FieldEditor {
    private Composite checkBoxBox;
    private final boolean useGroup;
    private final String[][] labelsAndValues;
    private final int numColumns;
    private Button[] checkBoxButtons;
    protected String result;

    public CheckBoxGroupFieldEditor(String name, String labeltext, int numColumns, String[][] labelsAndValues, Composite fieldEditorParent, boolean useGroup) {
        this.init(name, labeltext);
        this.numColumns = numColumns;
        this.labelsAndValues = (String[][])labelsAndValues.clone();
        this.useGroup = useGroup;
        this.createControl(fieldEditorParent);
    }

    protected abstract String calculateResult(String[][] var1);

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.checkBoxBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this.useGroup) {
            Control control = this.getCheckBoxControl(parent);
            GridData gd = new GridData(768);
            control.setLayoutData((Object)gd);
        } else {
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            control.setLayoutData((Object)gd);
            control = this.getCheckBoxControl(parent);
            gd = new GridData();
            gd.horizontalSpan = numColumns;
            control.setLayoutData((Object)gd);
        }
    }

    private Control getCheckBoxControl(Composite parent) {
        if (this.checkBoxBox == null) {
            Font font = parent.getFont();
            if (this.useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.checkBoxBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.checkBoxBox.setLayout((Layout)layout);
            } else {
                this.checkBoxBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.checkBoxBox.setLayout((Layout)layout);
                this.checkBoxBox.setFont(font);
            }
            this.checkBoxButtons = new Button[this.labelsAndValues.length];
            int i = 0;
            while (i < this.labelsAndValues.length) {
                Button checkBox;
                this.checkBoxButtons[i] = checkBox = new Button(this.checkBoxBox, 16416);
                String[] labelAndValue = this.labelsAndValues[i];
                checkBox.setText(labelAndValue[0]);
                checkBox.setData((Object)labelAndValue[1]);
                checkBox.setFont(font);
                checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        CheckBoxGroupFieldEditor.this.setPresentsDefaultValue(false);
                        String oldResult = CheckBoxGroupFieldEditor.this.result;
                        CheckBoxGroupFieldEditor.this.result = CheckBoxGroupFieldEditor.this.gatherSettings();
                        CheckBoxGroupFieldEditor.this.fireValueChanged("field_editor_value", oldResult, CheckBoxGroupFieldEditor.this.result);
                    }
                });
                ++i;
            }
            this.checkBoxBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CheckBoxGroupFieldEditor.this.checkBoxBox = null;
                    CheckBoxGroupFieldEditor.this.checkBoxButtons = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBoxBox, parent);
        }
        return this.checkBoxBox;
    }

    private String gatherSettings() {
        String[][] settings = new String[this.checkBoxButtons.length][3];
        int i = 0;
        while (i < this.checkBoxButtons.length) {
            Button currentCheckBox = this.checkBoxButtons[i];
            String name = currentCheckBox.getText();
            String value = (String)currentCheckBox.getData();
            String checked = String.valueOf(currentCheckBox.getSelection());
            settings[i] = new String[]{name, value, checked};
            ++i;
        }
        return this.calculateResult(settings);
    }

    protected void doLoad() {
        this.setupControls(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.setupControls(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    private void setupControls(String valueToSet) {
        int i = 0;
        while (i < this.checkBoxButtons.length) {
            Button currentCheckBox = this.checkBoxButtons[i];
            currentCheckBox.setSelection(this.isSelected(currentCheckBox.getText(), valueToSet));
            ++i;
        }
    }

    protected void doStore() {
        if (this.result == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.result);
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (!this.useGroup) {
            super.setEnabled(enabled, parent);
        }
        Button[] buttonArray = this.checkBoxButtons;
        int n = this.checkBoxButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            button.setEnabled(enabled);
            ++n2;
        }
    }

    protected abstract boolean isSelected(String var1, String var2);
}

