/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.preferences.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.xtext.ui.core.editor.preferences.fields.AbstractDetailsPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMasterDetailsFieldEditor
extends FieldEditor {
    private org.eclipse.swt.widgets.List masterList;
    protected final List<?> items;
    private AbstractDetailsPart fieldEditorPreferencePage;

    public AbstractMasterDetailsFieldEditor(String name, String labelText, Composite composite, IPreferenceStore preferenceStore, List<?> list) {
        this.items = list;
        this.init(name, labelText);
        this.setPreferenceStore(preferenceStore);
        this.createControl(composite);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.masterList.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.masterList = this.getMasterList(parent);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        this.masterList.setLayoutData((Object)gd);
        this.fieldEditorPreferencePage = this.createDetailsPart();
        this.fieldEditorPreferencePage.createControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.fieldEditorPreferencePage.getControl().setLayoutData((Object)gd);
    }

    protected abstract AbstractDetailsPart createDetailsPart();

    private org.eclipse.swt.widgets.List getMasterList(Composite parent) {
        if (this.masterList == null) {
            this.masterList = new org.eclipse.swt.widgets.List(parent, 2820);
            this.masterList.setFont(parent.getFont());
            ArrayList<String> names = new ArrayList<String>();
            for (Object ttd : this.items) {
                if (this.label(ttd) != null) {
                    names.add(this.label(ttd));
                    continue;
                }
                names.add("<unnamed> (" + this.identifier(ttd) + ")");
            }
            this.masterList.setItems(names.toArray(new String[0]));
            this.masterList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractMasterDetailsFieldEditor.this.doLoad();
                }
            });
            this.masterList.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractMasterDetailsFieldEditor.this.masterList = null;
                }
            });
            this.masterList.setSelection(0);
        }
        return this.masterList;
    }

    protected abstract String identifier(Object var1);

    protected abstract String label(Object var1);

    protected void doLoad() {
        this.fieldEditorPreferencePage.load(this.calculateClientPreferencePrefix());
    }

    protected void doLoadDefault() {
        this.fieldEditorPreferencePage.loadDefaults(this.calculateClientPreferencePrefix());
    }

    protected void doStore() {
        this.fieldEditorPreferencePage.performOk();
    }

    public void store() {
        this.doStore();
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getMasterList(parent).setEnabled(enabled);
    }

    private String calculateClientPreferencePrefix() {
        return String.valueOf(this.getPreferenceName()) + '.' + this.identifier(this.selectedObject());
    }

    private Object selectedObject() {
        int selectionIndex = this.masterList.getSelectionIndex();
        Object tokenTypeDef = this.items.get(selectionIndex);
        return tokenTypeDef;
    }
}

