/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.preferences;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtext.ui.core.internal.Activator;

public abstract class AbstractPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Logger log = Logger.getLogger(AbstractPreferencePage.class);
    private static final String USE_PROJECT_SETTINGS = "useProjectSettings";
    private IWorkbench workbench;
    private IProject project;
    private Button useProjectSettingsButton;
    private final List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private Link link;
    @Inject
    @Named(value="languageName")
    private String languageName;

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IProject.class);
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public boolean isPropertyPage() {
        return this.project != null;
    }

    public AbstractPreferencePage() {
        super(1);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        String qualifier = this.getQualifier();
        if (this.isPropertyPage()) {
            ProjectScope projectScope = new ProjectScope(this.currentProject());
            ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)projectScope, qualifier);
            scopedPreferenceStore.setSearchContexts(new IScopeContext[]{projectScope, new InstanceScope(), new ConfigurationScope()});
            return scopedPreferenceStore;
        }
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), qualifier);
        scopedPreferenceStore.setSearchContexts(new IScopeContext[]{new InstanceScope(), new ConfigurationScope()});
        return scopedPreferenceStore;
    }

    protected String getQualifier() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createUseProjectSettingsControls(parent);
        }
        return super.createContents(parent);
    }

    private void createUseProjectSettingsControls(Composite parent) {
        Composite projectSettingsParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        projectSettingsParent.setLayout((Layout)layout);
        projectSettingsParent.setLayoutData((Object)new GridData(768));
        this.useProjectSettingsButton = new Button(projectSettingsParent, 32);
        this.useProjectSettingsButton.setText("Enable pr&oject specific settings");
        this.useProjectSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPreferencePage.this.handleUseProjectSettings();
                log.debug((Object)"AbstractPreferencePage.widgetSelected()");
            }
        });
        this.link = new Link(projectSettingsParent, 0);
        this.link.setFont(projectSettingsParent.getFont());
        this.link.setText("<A>Configure Workspace Settings...</A>");
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = AbstractPreferencePage.this.qualifiedName();
                PreferencesUtil.createPreferenceDialogOn((Shell)AbstractPreferencePage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
            }
        });
        this.link.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        Label horizontalLine = new Label(projectSettingsParent, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        horizontalLine.setFont(projectSettingsParent.getFont());
        try {
            this.useProjectSettingsButton.setSelection(Boolean.valueOf(this.currentProject().getPersistentProperty(new QualifiedName(this.qualifiedName(), USE_PROJECT_SETTINGS))).booleanValue());
        }
        catch (CoreException e) {
            log.error((Object)"Error", (Throwable)e);
        }
    }

    private IProject currentProject() {
        if (this.project == null) {
            throw new IllegalStateException("Not a property page case, but current project was requested.");
        }
        return this.project;
    }

    protected String getLanguageName() {
        return this.languageName;
    }

    protected String qualifiedName() {
        return this.languageName;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.handleUseProjectSettings();
        }
    }

    protected void addField(FieldEditor editor) {
        editor.setPreferenceName(String.valueOf(this.qualifiedName()) + "." + editor.getPreferenceName());
        this.editors.add(editor);
        super.addField(editor);
    }

    private void handleUseProjectSettings() {
        boolean isUseProjectSettings = this.useProjectSettingsButton.getSelection();
        this.link.setEnabled(!isUseProjectSettings);
        if (!isUseProjectSettings) {
            ((ScopedPreferenceStore)this.getPreferenceStore()).setSearchContexts(new IScopeContext[]{new InstanceScope(), new ConfigurationScope()});
        } else {
            ((ScopedPreferenceStore)this.getPreferenceStore()).setSearchContexts(new IScopeContext[]{new ProjectScope(this.currentProject()), new InstanceScope(), new ConfigurationScope()});
        }
        this.updateFieldEditors(isUseProjectSettings);
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            if (enabled) {
                editor.load();
            } else {
                editor.loadDefault();
            }
            editor.setEnabled(enabled, parent);
        }
    }

    public boolean performOk() {
        boolean retVal = super.performOk();
        if (retVal && this.isPropertyPage()) {
            try {
                this.currentProject().setPersistentProperty(new QualifiedName(this.qualifiedName(), USE_PROJECT_SETTINGS), String.valueOf(this.useProjectSettingsButton.getSelection()));
                ((IPersistentPreferenceStore)this.getPreferenceStore()).save();
            }
            catch (Exception e) {
                log.error((Object)"Error", (Throwable)e);
                retVal = false;
            }
        }
        return retVal;
    }
}

