/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.model;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.core.editor.model.XtextDocument;

public class XtextDocumentProvider
extends FileDocumentProvider {
    private static final Logger log = Logger.getLogger(XtextDocumentProvider.class);
    @Inject
    private Provider<XtextDocument> document;
    private final List<IResourceChangeListener> resourceChangeListener = new ArrayList<IResourceChangeListener>();

    protected IDocument createEmptyDocument() {
        XtextDocument xtextDocument = (XtextDocument)this.document.get();
        ReferencedResourcesUpdater listener = new ReferencedResourcesUpdater(xtextDocument);
        this.resourceChangeListener.add(listener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        return xtextDocument;
    }

    protected void setupDocument(Object element, IDocument document) {
        ((XtextDocument)document).setInput((IEditorInput)element);
    }

    protected void disconnected() {
        super.disconnected();
        for (IResourceChangeListener listener : this.resourceChangeListener) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
        }
        this.resourceChangeListener.clear();
    }

    private final class ReferencedResourcesUpdater
    implements IResourceChangeListener {
        private final XtextDocument document;

        private ReferencedResourcesUpdater(XtextDocument document) {
            this.document = document;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this.document);
            try {
                event.getDelta().accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (!visitor.deltas.isEmpty()) {
                new Job("updating resourceset"){

                    protected IStatus run(IProgressMonitor monitor) {
                        ReferencedResourcesUpdater.this.document.modify(new IUnitOfWork.Void<XtextResource>(){

                            public void process(XtextResource arg) throws Exception {
                                for (IResourceDelta delta : visitor.deltas) {
                                    IResource res = delta.getResource();
                                    String string = res.getFullPath().lastSegment();
                                    ResourceSet set = arg.getResourceSet();
                                    int i = 0;
                                    while (i < set.getResources().size()) {
                                        final Resource emfResource = (Resource)set.getResources().get(i);
                                        if (emfResource != null && string.equals(emfResource.getURI().lastSegment())) {
                                            switch (delta.getKind()) {
                                                case 2: {
                                                    ReferencedResourcesUpdater.this.document.modify(new IUnitOfWork.Void<XtextResource>(){

                                                        public void process(XtextResource arg) throws Exception {
                                                            emfResource.unload();
                                                        }
                                                    });
                                                    if (emfResource.getResourceSet() == null) break;
                                                    set.getResources().remove((Object)emfResource);
                                                    break;
                                                }
                                                case 4: {
                                                    ReferencedResourcesUpdater.this.document.modify(new IUnitOfWork.Void<XtextResource>(){

                                                        public void process(XtextResource arg) throws Exception {
                                                            emfResource.unload();
                                                            try {
                                                                emfResource.load(null);
                                                            }
                                                            catch (IOException e) {
                                                                log.error((Object)e.getMessage(), (Throwable)e);
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                        if (set.getResources().size() <= i || set.getResources().get(i) != emfResource) continue;
                                        ++i;
                                    }
                                }
                                arg.reparse(ReferencedResourcesUpdater.this.document.get());
                            }
                        });
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    private final class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final XtextDocument document;
        public final List<IResourceDelta> deltas = new ArrayList<IResourceDelta>();

        private ResourceDeltaVisitor(XtextDocument document) {
            this.document = document;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            int kind = delta.getKind();
            int flags = delta.getFlags();
            if ((kind == 2 || kind == 4 && (0x100 & flags) != 0) && this.document.isReferenced(res)) {
                this.deltas.add(delta);
            }
            return true;
        }
    }
}

