/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.model;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.Document;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.xtext.concurrent.IEObjectHandle;
import org.eclipse.xtext.concurrent.IStateAccess;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.core.editor.XtextReadonlyEditorInput;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.core.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.core.editor.utils.ValidationJob;
import org.eclipse.xtext.ui.core.util.JdtClasspathUriResolver;
import org.eclipse.xtext.validation.CheckMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextDocument
extends Document
implements IXtextDocument {
    private XtextResourceSet resourceSet = null;
    private XtextResource resource = null;
    private IFile file;
    private final ListenerList modelListeners = new ListenerList(1);
    private final ListenerList xtextDocumentObservers = new ListenerList(1);
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private ValidationJob.Factory validationJobFactory;
    private final XtextDocumentLocker stateAccess = new XtextDocumentLocker();
    private static final Logger log = Logger.getLogger(XtextDocument.class);
    private final Object validationLock = new Object();
    private transient Job validationJob;

    public void setInput(IEditorInput editorInput) {
        IJavaProject javaProject;
        this.file = ResourceUtil.getFile((IEditorInput)editorInput);
        this.resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
        if (this.file != null && (javaProject = this.getIJavaProject((IResource)this.file)) != null) {
            this.resourceSet.setClasspathUriResolver((IClasspathUriResolver)new JdtClasspathUriResolver());
            this.resourceSet.setClasspathURIContext((Object)javaProject);
        }
        IPath path = null;
        Resource aResource = null;
        URI uri = null;
        if (this.file != null) {
            path = this.file.getFullPath();
            uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
        } else if (editorInput instanceof XtextReadonlyEditorInput) {
            uri = ((XtextReadonlyEditorInput)editorInput).getURI();
        } else {
            IStorageEditorInput storageInput = (IStorageEditorInput)editorInput;
            try {
                path = storageInput.getStorage().getFullPath();
                uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
        aResource = this.resourceSet.createResource(uri, "");
        if (!(aResource instanceof XtextResource)) {
            throw new IllegalStateException("The resource factory registered for " + path + " does not yield an XtextResource. Make sure the right resource factory has been registered.");
        }
        this.resource = (XtextResource)aResource;
        if (this.resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)this.resource).setEagerLinking(true);
        }
        this.resource.setValidationDisabled(this.file == null);
    }

    public boolean isReferenced(IResource anIResource) {
        if (!(anIResource instanceof IFile) || this.resource == null || this.resource.getResourceSet() == null) {
            return false;
        }
        EList resources = this.resource.getResourceSet().getResources();
        HashMap<String, Resource> uriToRes = new HashMap<String, Resource>();
        for (Resource res : resources) {
            if (res == this.resource) continue;
            URI uri = res.getURI();
            uriToRes.put(uri.lastSegment(), res);
        }
        return uriToRes.containsKey(anIResource.getFullPath().lastSegment());
    }

    private IJavaProject getIJavaProject(IResource resource) {
        IJavaProject create = JavaCore.create((IProject)resource.getProject());
        if (create.exists()) {
            return create;
        }
        return null;
    }

    public <T> T readOnly(IUnitOfWork<T, XtextResource> work) {
        return (T)this.stateAccess.readOnly(work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T modify(IUnitOfWork<T, XtextResource> work) {
        try {
            Object object = this.validationLock;
            synchronized (object) {
                if (this.validationJob != null) {
                    this.validationJob.cancel();
                }
            }
            Object object2 = this.stateAccess.modify(work);
            return (T)object2;
        }
        finally {
            this.checkAndUpdateMarkers();
        }
    }

    private void ensureThatStateIsNotReturned(Object exec, IUnitOfWork<?, XtextResource> uow) {
    }

    @Override
    public void addModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        this.modelListeners.add((Object)listener);
    }

    @Override
    public void removeModelListener(IXtextModelListener listener) {
        Assert.isNotNull((Object)listener);
        this.modelListeners.remove((Object)listener);
    }

    private void notifyModelListeners(XtextResource res) {
        Object[] listeners = this.modelListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IXtextModelListener)listeners[i]).modelChanged(res);
            ++i;
        }
    }

    @Override
    public void addXtextDocumentContentObserver(IXtextDocumentContentObserver observer) {
        this.addDocumentListener(observer);
        this.xtextDocumentObservers.add((Object)observer);
    }

    @Override
    public void removeXtextDocumentContentObserver(IXtextDocumentContentObserver observer) {
        this.xtextDocumentObservers.remove((Object)observer);
        this.removeDocumentListener(observer);
    }

    private <T> void updateContentBeforeRead() {
        Object[] listeners = this.xtextDocumentObservers.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IXtextDocumentContentObserver)listeners[i]).performNecessaryUpdates(this.stateAccess);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateMarkers() {
        Object object = this.validationLock;
        synchronized (object) {
            if (this.validationJob != null) {
                this.validationJob.cancel();
            }
            this.validationJob = this.validationJobFactory.create(this, this.file, CheckMode.FAST_ONLY, true);
            this.validationJob.schedule(250L);
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        URI uri = this.resource.getURI();
        if ((adapterType == IFile.class || adapterType == IResource.class) && uri.isPlatformResource()) {
            return (T)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }

    @Override
    public <T extends EObject> IEObjectHandle<T> createHandle(T obj) {
        return new IEObjectHandle.DefaultImpl(obj, (IStateAccess)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class XtextDocumentLocker
    extends IStateAccess.AbstractImpl<XtextResource>
    implements IXtextDocumentContentObserver.Processor {
        private XtextDocumentLocker() {
        }

        protected XtextResource getState() {
            return XtextDocument.this.resource;
        }

        protected void beforeReadOnly(XtextResource res, IUnitOfWork<?, XtextResource> work) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("read - " + Thread.currentThread().getName()));
            }
            XtextDocument.this.updateContentBeforeRead();
        }

        protected void beforeModify(XtextResource state, IUnitOfWork<?, XtextResource> work) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("write - " + Thread.currentThread().getName()));
            }
        }

        protected void afterReadOnly(XtextResource res, Object result, IUnitOfWork<?, XtextResource> work) {
            XtextDocument.this.ensureThatStateIsNotReturned(result, work);
        }

        protected void afterModify(XtextResource res, Object result, IUnitOfWork<?, XtextResource> work) {
            XtextDocument.this.ensureThatStateIsNotReturned(result, work);
            XtextDocument.this.notifyModelListeners(XtextDocument.this.resource);
        }

        @Override
        public <T> T process(IUnitOfWork<T, XtextResource> transaction) {
            if (transaction != null) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("process - " + Thread.currentThread().getName()));
                    }
                    Object object = this.modify(transaction);
                    return (T)object;
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            return null;
        }
    }
}

