/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor.formatting;

import com.google.inject.Inject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.xtext.concurrent.IUnitOfWork;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.core.editor.formatting.IContentFormatterFactory;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.core.editor.reconciler.ReplaceRegion;

public class ContentFormatterFactory
implements IContentFormatterFactory {
    @Inject
    protected INodeModelFormatter formatter;

    public IContentFormatter createConfiguredFormatter(SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        return new ContentFormatter();
    }

    public class ContentFormatter
    implements IContentFormatter {
        public void format(IDocument document, IRegion region) {
            IXtextDocument doc = (IXtextDocument)document;
            ReplaceRegion r = (ReplaceRegion)doc.readOnly(new FormattingUnitOfWork(region));
            try {
                if (r != null) {
                    doc.replace(r.getOffset(), r.getLength(), r.getText());
                }
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        public IFormattingStrategy getFormattingStrategy(String contentType) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FormattingUnitOfWork
    implements IUnitOfWork<ReplaceRegion, XtextResource> {
        protected final IRegion region;

        public FormattingUnitOfWork(IRegion region) {
            this.region = region;
        }

        public ReplaceRegion exec(XtextResource state) throws Exception {
            INodeModelFormatter.IFormattedRegion r = ContentFormatterFactory.this.formatter.format(state.getParseResult().getRootNode(), this.region.getOffset(), this.region.getLength());
            return new ReplaceRegion(r.getOffset(), r.getLenght(), r.getFormattedText());
        }
    }
}

