/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.ui.core.XtextUIMessages;
import org.eclipse.xtext.ui.core.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.core.editor.IXtextEditorAware;
import org.eclipse.xtext.ui.core.editor.XtextMarkerRulerAction;
import org.eclipse.xtext.ui.core.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.core.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.core.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.core.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.ui.core.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.core.editor.reconciler.XtextReconciler;
import org.eclipse.xtext.ui.core.editor.syntaxcoloring.IHighlightingHelper;
import org.eclipse.xtext.ui.core.editor.toggleComments.ToggleSLCommentAction;
import org.eclipse.xtext.ui.core.editor.utils.ValidationJob;
import org.eclipse.xtext.ui.core.internal.Activator;
import org.eclipse.xtext.validation.CheckMode;

public class XtextEditor
extends TextEditor {
    private static final Logger log = Logger.getLogger(XtextEditor.class);
    public static final String ID = "org.eclipse.xtext.baseEditor";
    @Inject
    private XtextSourceViewerConfiguration sourceViewerConfiguration;
    private IContentOutlinePage outlinePage;
    @Inject(optional=true)
    private Provider<IContentOutlinePage> outlinePageProvider;
    @Inject
    private Provider<XtextDocumentProvider> documentProvider;
    @Inject
    private XtextSourceViewer.Factory sourceViewerFactory;
    @Inject
    private IHighlightingHelper highlightingHelper;
    @Inject
    private ValidationJob.Factory validationJobFactory;
    private ValidationJob validationJob;
    private ISelectionChangedListener selectionChangedListener;
    private String languageName;
    private ProjectionSupport projectionSupport;

    public XtextEditor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Xtext Editor. Instance: [" + ((Object)((Object)this)).toString() + "]"));
        }
    }

    public IXtextDocument getDocument() {
        return XtextDocumentUtil.get(this.getSourceViewer());
    }

    @Inject
    public void setLanguageName(@Named(value="languageName") String name) {
        this.languageName = name;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doSetInput:" + input));
            log.debug((Object)("Editor instance is [" + ((Object)((Object)this)).toString() + "]"));
        }
        super.doSetInput(input);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init:" + input));
        }
        this.setDocumentProvider((IDocumentProvider)this.documentProvider.get());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{Activator.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()}));
        super.init(site, input);
    }

    public XtextSourceViewerConfiguration getXtextSourceViewerConfiguration() {
        return this.sourceViewerConfiguration;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.xtext.ui.core.XtextEditorScope"});
    }

    public IResource getResource() {
        Object adapter = this.getEditorInput().getAdapter(IResource.class);
        if (adapter != null) {
            return (IResource)adapter;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    private IContentOutlinePage getContentOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createOutlinePage();
        }
        return this.outlinePage;
    }

    private IContentOutlinePage createOutlinePage() {
        IContentOutlinePage page = null;
        if (this.outlinePageProvider != null && (page = (IContentOutlinePage)this.outlinePageProvider.get()) != null) {
            if (page instanceof ISourceViewerAware) {
                ((ISourceViewerAware)page).setSourceViewer(this.getSourceViewer());
            }
            if (page instanceof IXtextEditorAware) {
                ((IXtextEditorAware)page).setEditor(this);
            }
        }
        return page;
    }

    public void doSelectionChanged(ISelection selection) {
    }

    public void outlinePageClosed() {
        if (this.outlinePage != null) {
            this.outlinePage = null;
            this.resetHighlightRange();
        }
    }

    protected void createActions() {
        ToggleSLCommentAction action;
        super.createActions();
        if (this.getSourceViewerConfiguration().getContentFormatter(this.getSourceViewer()) != null) {
            action = new TextOperationAction(XtextUIMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
            action.setActionDefinitionId("org.eclipse.xtext.ui.FormatAction");
            this.setAction("Format", (IAction)action);
            this.markAsStateDependentAction("Format", true);
            this.markAsSelectionDependentAction("Format", true);
        }
        action = new ToggleSLCommentAction(XtextUIMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.xtext.ui.ToggleCommentAction");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        this.markAsSelectionDependentAction("ToggleComment", true);
        this.configureToggleCommentAction(action);
        XtextMarkerRulerAction markerAction = new XtextMarkerRulerAction(XtextUIMessages.getResourceBundle(), "XtextSelectAnnotationRulerAction.", (ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("RulerClick", (IAction)markerAction);
    }

    private void configureToggleCommentAction(ToggleSLCommentAction action) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        action.configure(sourceViewer, configuration);
    }

    public boolean isContentAssistAvailable() {
        return this.getSourceViewerConfiguration().getContentAssistant(this.getSourceViewer()) != null;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating Xtext source viewer.");
        }
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        XtextSourceViewer projectionViewer = this.sourceViewerFactory.createSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)projectionViewer);
        return projectionViewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.install();
        this.installHighlightingHelper();
        this.installSelectionChangedListener();
    }

    private void installSelectionChangedListener() {
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XtextEditor.this.updateStatusLine();
            }
        };
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider postSelectionProvider = (IPostSelectionProvider)selectionProvider;
            postSelectionProvider.addPostSelectionChangedListener(this.selectionChangedListener);
        } else {
            this.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        }
    }

    private void installHighlightingHelper() {
        if (this.highlightingHelper != null) {
            this.highlightingHelper.install(this, (XtextSourceViewer)this.getSourceViewer());
        }
    }

    private void uninstallHighlightingHelper() {
        if (this.highlightingHelper != null) {
            this.highlightingHelper.uninstall();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.projectionSupport != null) {
            this.projectionSupport.dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage = null;
        }
        this.uninstallHighlightingHelper();
        this.uninstallSelectionChangedListener();
    }

    private void uninstallSelectionChangedListener() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider postSelectionProvider = (IPostSelectionProvider)selectionProvider;
                postSelectionProvider.removePostSelectionChangedListener(this.selectionChangedListener);
            } else {
                selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            }
        }
    }

    public ISourceViewer getInternalSourceViewer() {
        return this.getSourceViewer();
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        super.performSaveAs(progressMonitor);
        this.doOnSaveValidation(progressMonitor);
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        super.performSave(overwrite, progressMonitor);
        this.doOnSaveValidation(progressMonitor);
    }

    protected void performRevert() {
        super.performRevert();
        this.doOnSaveValidation((IProgressMonitor)new NullProgressMonitor());
    }

    private void doOnSaveValidation(IProgressMonitor progressMonitor) {
        if (this.validationJob == null) {
            this.validationJob = this.validationJobFactory.create(this.getDocument(), (IFile)this.getResource(), CheckMode.NORMAL_AND_FAST, true);
        }
        this.validationJob.cancel();
        try {
            this.validationJob.join();
            Job.getJobManager().join((Object)XtextReconciler.class.getName(), progressMonitor);
        }
        catch (InterruptedException e) {
            log.error((Object)"Error joining canceled ValidationJob", (Throwable)e);
        }
        this.validationJob.schedule();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        if (this.getSourceViewer() == null) {
            return;
        }
        boolean tokenStyleChanged = event.getProperty().contains(".syntaxColorer.tokenStyles");
        if (tokenStyleChanged) {
            this.initializeViewerColors(this.getSourceViewer());
            this.getSourceViewer().invalidateTextPresentation();
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 4];
        more[0] = String.valueOf(this.getLanguageName()) + ".editor";
        more[1] = this.getLanguageName();
        more[2] = String.valueOf(this.getLanguageName()) + ".templates";
        more[3] = String.valueOf(this.getLanguageName()) + ".coloring";
        System.arraycopy(ids, 0, more, 4, ids.length);
        return more;
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        String message = null;
        if (annotation != null) {
            this.updateMarkerViews(annotation);
            if (this.isProblemMarkerAnnotation(annotation)) {
                message = annotation.getText();
            }
        }
        this.setStatusLineMessage(message);
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        if (model == null) {
            return null;
        }
        Iterator iterator = model instanceof IAnnotationModelExtension2 ? ((IAnnotationModelExtension2)model).getAnnotationIterator(offset, length, true, true) : model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation a = (Annotation)iterator.next();
            Position p = model.getPosition(a);
            if (p == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    private boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

