/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.ui.core.editor.ReadonlyStorage;

public class ReadonlyFileStorage
extends ReadonlyStorage {
    private final File file;

    public ReadonlyFileStorage(File file, URI uri) throws IOException {
        super(URI.createURI((String)(String.valueOf(uri.scheme()) + ":" + uri.devicePath())));
        this.file = file;
        if (!file.exists() || file.isDirectory()) {
            throw new IOException("file does not exist or is a directory: " + file.getCanonicalPath());
        }
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public IPath getFullPath() {
        return new Path(this.getURI().toString());
    }

    public String getName() {
        return this.file.getName();
    }
}

