/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.xtext.ui.core.editor.ReadonlyStorage;

public class ReadonlyArchiveStorage
extends ReadonlyStorage {
    private final ZipFile file;
    private final ZipEntry entry;

    public ReadonlyArchiveStorage(URI uri) throws IOException {
        super(URI.createURI((String)(String.valueOf(uri.scheme()) + ":" + uri.devicePath())));
        URI archiveUri = URI.createURI((String)uri.authority());
        String archive = null;
        archive = archiveUri.isFile() ? archiveUri.toFileString() : (archiveUri.isPlatformResource() ? archiveUri.toPlatformString(true) : archiveUri.toString());
        archive = archive.substring(0, archive.length() - 1);
        File file = new File(archive);
        if (!file.exists()) {
            throw new IOException("file does not exist: " + uri);
        }
        this.file = new ZipFile(file);
        String path = uri.path().substring(1);
        this.entry = this.file.getEntry(path);
    }

    public InputStream getContents() throws CoreException {
        try {
            InputStream result = this.file.getInputStream(this.entry);
            return result;
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public IPath getFullPath() {
        return new Path(this.getURI().toString());
    }

    public String getName() {
        return this.entry.getName();
    }
}

