/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerUtil {
    private static final Logger log = Logger.getLogger(MarkerUtil.class);
    public static final String CHECK_MARKER_ID = "org.eclipse.xtext.ui.core.check";
    public static final String EXPENSIVE_CHECK_MARKER_ID = "org.eclipse.xtext.ui.core.check.expensive";
    public static final String NORMAL_CHECK_MARKER_ID = "org.eclipse.xtext.ui.core.check.normal";
    public static final String FAST_CHECK_MARKER_ID = "org.eclipse.xtext.ui.core.check.fast";
    public static final String DEFAULT_MARKER_ID = "org.eclipse.emf.ecore.diagnostic";
    private static Map<CheckMode, List<String>> checkMode2MarkerIDs = new HashMap<CheckMode, List<String>>();

    public static void addMarkers(IFile file, List<Map<String, Object>> issues, CheckMode checkMode, boolean deleteOldMarkers, IProgressMonitor monitor) {
        try {
            new AddMarkersOperation(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)file), issues, file, checkMode, deleteOldMarkers).run(monitor);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Could not create marker.", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)"Could not create marker.", (Throwable)e);
        }
    }

    public static String getMarkerID(Diagnostic diagnostic) {
        String markerID;
        CheckType checkType;
        if (diagnostic instanceof AbstractDeclarativeValidator.DiagnosticImpl && (checkType = ((AbstractDeclarativeValidator.DiagnosticImpl)diagnostic).getCheckType()) != null && (markerID = MarkerUtil.getMarkerID(checkType)) != null) {
            return markerID;
        }
        return DEFAULT_MARKER_ID;
    }

    private static String getMarkerID(CheckType checkType) {
        switch (checkType) {
            case EXPENSIVE: {
                return EXPENSIVE_CHECK_MARKER_ID;
            }
            case FAST: {
                return FAST_CHECK_MARKER_ID;
            }
            case NORMAL: {
                return NORMAL_CHECK_MARKER_ID;
            }
        }
        log.warn((Object)("No marker type defined for " + checkType.name()));
        return null;
    }

    public static List<String> getMarkerIDs(CheckMode checkMode) {
        List<String> markerIDs = checkMode2MarkerIDs.get(checkMode);
        if (markerIDs == null) {
            markerIDs = new ArrayList<String>();
            CheckType[] checkTypeArray = CheckType.values();
            int n = checkTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                String markerID;
                CheckType checkType = checkTypeArray[n2];
                if (checkMode.shouldCheck(checkType) && (markerID = MarkerUtil.getMarkerID(checkType)) != null) {
                    markerIDs.add(markerID);
                }
                ++n2;
            }
            markerIDs.add(DEFAULT_MARKER_ID);
            checkMode2MarkerIDs.put(checkMode, markerIDs);
        }
        return markerIDs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AddMarkersOperation
    extends WorkspaceModifyOperation {
        private final List<Map<String, Object>> issues;
        private final IFile file;
        private final CheckMode checkMode;
        private final boolean deleteMarkers;

        public AddMarkersOperation(ISchedulingRule rule, List<Map<String, Object>> issues, IFile file, CheckMode checkMode, boolean deleteMarkers) {
            super(rule);
            this.issues = issues;
            this.file = file;
            this.checkMode = checkMode;
            this.deleteMarkers = deleteMarkers;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            if (!this.file.exists()) {
                return;
            }
            if (this.deleteMarkers) {
                for (String string : MarkerUtil.getMarkerIDs(this.checkMode)) {
                    this.file.deleteMarkers(string, false, 2);
                }
            }
            if (!this.issues.isEmpty()) {
                for (Map map : this.issues) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    Diagnostic diagnostic = (Diagnostic)map.remove("EmfDiagnostic");
                    String markerID = MarkerUtil.getMarkerID(diagnostic);
                    IMarker marker = this.file.createMarker(markerID);
                    Object lNr = map.get("lineNumber");
                    String lineNR = "";
                    if (lNr != null) {
                        lineNR = "line: " + lNr + " ";
                    }
                    map.put("location", String.valueOf(lineNR) + this.file.getFullPath().toString());
                    marker.setAttributes(map);
                }
            }
        }
    }
}

