/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.ui.core.editor.IDiagnosticConverter;
import org.eclipse.xtext.ui.core.editor.IXtextResourceChecker;
import org.eclipse.xtext.validation.CancelIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXtextResourceChecker
implements IXtextResourceChecker {
    private static final Logger log = Logger.getLogger(DefaultXtextResourceChecker.class);
    @Inject
    private Diagnostician diagnostician;
    @Inject
    private IDiagnosticConverter converter;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> check(Resource resource, Map<?, ?> context, final IProgressMonitor monitor) {
        ArrayList<Map<String, Object>> markers = new ArrayList<Map<String, Object>>(resource.getErrors().size() + resource.getWarnings().size());
        IDiagnosticConverter.Acceptor acceptor = this.createAcceptor(markers);
        try {
            int i = 0;
            while (i < resource.getErrors().size()) {
                this.markerFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getErrors().get(i), 2, acceptor);
                ++i;
            }
            if (monitor.isCanceled()) {
                return null;
            }
            i = 0;
            while (i < resource.getWarnings().size()) {
                this.markerFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getWarnings().get(i), 1, acceptor);
                ++i;
            }
            if (monitor.isCanceled()) {
                return null;
            }
            boolean syntaxDiagFail = !markers.isEmpty();
            this.logCheckStatus(resource, syntaxDiagFail, "Syntax");
            for (EObject ele : resource.getContents()) {
                try {
                    HashMap options = Maps.newHashMap(context);
                    options.put("org.eclipse.xtext.validation.CancellableDiagnostician.CANCEL_INDICATOR", new CancelIndicator(){

                        public boolean isCancelled() {
                            return monitor.isCanceled();
                        }
                    });
                    Diagnostic diagnostic = this.diagnostician.validate(ele, (Map)options);
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (!diagnostic.getChildren().isEmpty()) {
                        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                            this.markerFromEValidatorDiagnostic(childDiagnostic, acceptor);
                        }
                        continue;
                    }
                    this.markerFromEValidatorDiagnostic(diagnostic, acceptor);
                }
                catch (RuntimeException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return markers;
    }

    protected IDiagnosticConverter.Acceptor createAcceptor(List<Map<String, Object>> result) {
        return new ListBasedMarkerAcceptor(result);
    }

    private void logCheckStatus(Resource resource, boolean parserDiagFail, String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(string) + " check " + (parserDiagFail ? "FAIL" : "OK") + "! Resource: " + resource.getURI()));
        }
    }

    protected void markerFromXtextResourceDiagnostic(Resource.Diagnostic diagnostic, Object severity, IDiagnosticConverter.Acceptor acceptor) {
        this.converter.convertResourceDiagnostic(diagnostic, severity, acceptor);
    }

    protected void markerFromEValidatorDiagnostic(Diagnostic diagnostic, IDiagnosticConverter.Acceptor acceptor) {
        this.converter.convertValidatorDiagnostic(diagnostic, acceptor);
    }

    public void setDiagnostician(Diagnostician diagnostician) {
        this.diagnostician = diagnostician;
    }

    public Diagnostician getDiagnostician() {
        return this.diagnostician;
    }

    public void setDiagnosticConverter(IDiagnosticConverter converter) {
        this.converter = converter;
    }

    public IDiagnosticConverter getDiagnosticConverter() {
        return this.converter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ListBasedMarkerAcceptor
    implements IDiagnosticConverter.Acceptor {
        private final List<Map<String, Object>> result;

        protected ListBasedMarkerAcceptor(List<Map<String, Object>> result) {
            this.result = result;
        }

        @Override
        public void accept(Map<String, Object> marker) {
            if (marker != null) {
                this.result.add(marker);
            }
        }
    }
}

