/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.ui.core.editor.IDiagnosticConverter;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDiagnosticConverter
implements IDiagnosticConverter {
    @Override
    public void convertResourceDiagnostic(Resource.Diagnostic diagnostic, Object severity, IDiagnosticConverter.Acceptor acceptor) {
        HashMap<String, Object> marker = new HashMap<String, Object>();
        marker.put("severity", severity);
        marker.put("lineNumber", diagnostic.getLine());
        marker.put("message", diagnostic.getMessage());
        marker.put("priority", 0);
        if (diagnostic instanceof org.eclipse.xtext.diagnostics.Diagnostic) {
            org.eclipse.xtext.diagnostics.Diagnostic xtextDiagnostic = (org.eclipse.xtext.diagnostics.Diagnostic)diagnostic;
            marker.put("charStart", xtextDiagnostic.getOffset());
            marker.put("charEnd", xtextDiagnostic.getOffset() + xtextDiagnostic.getLength());
        }
        acceptor.accept(marker);
    }

    @Override
    public void convertValidatorDiagnostic(Diagnostic diagnostic, IDiagnosticConverter.Acceptor acceptor) {
        if (diagnostic.getSeverity() == 0) {
            return;
        }
        HashMap<String, Object> marker = new HashMap<String, Object>();
        int sever = 2;
        switch (diagnostic.getSeverity()) {
            case 2: {
                sever = 1;
                break;
            }
            case 1: {
                sever = 0;
            }
        }
        marker.put("severity", sever);
        Triple<Integer, Integer, Integer> locationData = this.getLocationData(diagnostic);
        if (locationData != null) {
            marker.put("lineNumber", locationData.getFirst());
            marker.put("charStart", locationData.getSecond());
            marker.put("charEnd", locationData.getThird());
        }
        marker.put("EmfDiagnostic", diagnostic);
        marker.put("message", diagnostic.getMessage());
        marker.put("priority", 0);
        acceptor.accept(marker);
    }

    protected Triple<Integer, Integer, Integer> getLocationData(Diagnostic diagnostic) {
        Iterator data = diagnostic.getData().iterator();
        Object causer = data.next();
        if (causer instanceof EObject) {
            EObject ele = (EObject)causer;
            Object feature = data.hasNext() ? data.next() : null;
            EStructuralFeature structuralFeature = this.resolveStructuralFeature(ele, feature);
            return this.getLocationData(ele, structuralFeature);
        }
        return null;
    }

    protected Triple<Integer, Integer, Integer> getLocationData(EObject obj, EStructuralFeature structuralFeature) {
        NodeAdapter nodeAdapter = NodeUtil.getNodeAdapter((EObject)obj);
        if (nodeAdapter != null) {
            List nodes;
            CompositeNode parserNode = nodeAdapter.getParserNode();
            if (structuralFeature != null && !(nodes = NodeUtil.findNodesForFeature((EObject)obj, (EStructuralFeature)structuralFeature)).isEmpty()) {
                parserNode = (AbstractNode)nodes.iterator().next();
            }
            Integer lineNumber = parserNode.getLine();
            int offset = parserNode.getOffset();
            Integer charStart = offset;
            Integer charEnd = offset + parserNode.getLength();
            return Tuples.create((Object)lineNumber, (Object)charStart, (Object)charEnd);
        }
        return null;
    }

    protected EStructuralFeature resolveStructuralFeature(EObject ele, Object feature) {
        if (feature instanceof String) {
            return ele.eClass().getEStructuralFeature((String)feature);
        }
        if (feature instanceof EStructuralFeature) {
            return (EStructuralFeature)feature;
        }
        if (feature instanceof Integer) {
            return ele.eClass().getEStructuralFeature(((Integer)feature).intValue());
        }
        return null;
    }
}

