/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core;

import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.core.IImageHelper;
import org.eclipse.xtext.util.PolymorphicDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLabelProvider
extends LabelProvider {
    private final PolymorphicDispatcher<String> textDispatcher = new PolymorphicDispatcher("text", 1, 1, Collections.singletonList(this), (PolymorphicDispatcher.ErrorHandler)new PolymorphicDispatcher.ErrorHandler<String>(){
        private final PolymorphicDispatcher<String> recoverText;
        {
            this.recoverText = new PolymorphicDispatcher("error_text", 2, 2, Collections.singletonList(SimpleLabelProvider.this));
        }

        public String handle(Object[] params, Throwable e) {
            return (String)this.recoverText.invoke(new Object[]{params[0], e});
        }
    });
    private final PolymorphicDispatcher<String> imageDispatcher = new PolymorphicDispatcher("image", 1, 1, Collections.singletonList(this), (PolymorphicDispatcher.ErrorHandler)new PolymorphicDispatcher.ErrorHandler<String>(){
        private final PolymorphicDispatcher<String> recoverImage;
        {
            this.recoverImage = new PolymorphicDispatcher("error_image", 2, 2, Collections.singletonList(SimpleLabelProvider.this));
        }

        public String handle(Object[] params, Throwable e) {
            return (String)this.recoverImage.invoke(new Object[]{params[0], e});
        }
    });
    @Inject
    private IImageHelper imageHelper;

    public String getText(Object element) {
        return (String)this.getTextDispatcher().invoke(new Object[]{element});
    }

    public Image getImage(Object element) {
        String imageName = (String)this.getImageDispatcher().invoke(new Object[]{element});
        return this.getImageHelper().getImage(imageName);
    }

    public String error_text(Object object, Exception e) {
        throw new WrappedException(e);
    }

    public String error_text(Object object, NullPointerException e) {
        return this.text(object);
    }

    public String text(Object object) {
        if (object instanceof EObject) {
            Object value;
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            EStructuralFeature feature = this.getLabelFeature(eClass);
            if (feature != null && (value = eObject.eGet(feature)) != null) {
                return value.toString();
            }
            return eClass.getName();
        }
        return "<unknown>";
    }

    public String error_image(Object object, Exception e) {
        throw new WrappedException(e);
    }

    public String error_image(Object object, NullPointerException e) {
        return this.image(object);
    }

    public String image(Object obj) {
        return null;
    }

    protected EStructuralFeature getLabelFeature(EClass eClass) {
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (eAttribute.isMany() || eAttribute.getEType().getInstanceClass() == FeatureMap.Entry.class) continue;
            if ("name".equalsIgnoreCase(eAttribute.getName())) {
                result = eAttribute;
                break;
            }
            if (result == null) {
                result = eAttribute;
                continue;
            }
            if (eAttribute.getEAttributeType().getInstanceClass() != String.class || result.getEAttributeType().getInstanceClass() == String.class) continue;
            result = eAttribute;
        }
        return result;
    }

    public void setImageHelper(IImageHelper imageHelper) {
        this.imageHelper = imageHelper;
    }

    public IImageHelper getImageHelper() {
        return this.imageHelper;
    }

    public PolymorphicDispatcher<String> getTextDispatcher() {
        return this.textDispatcher;
    }

    public PolymorphicDispatcher<String> getImageDispatcher() {
        return this.imageDispatcher;
    }
}

