/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.core.IImageHelper;

public class PluginImageHelper
implements IImageHelper {
    @Inject
    private AbstractUIPlugin plugin;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.core.PluginImageHelper.pathSuffix")
    private String pathSuffix = "icons/";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.core.PluginImageHelper.defaultImage")
    private String defaultImage = "default.gif";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.core.PluginImageHelper.notFound")
    private String notFound = "notFound.gif";

    public Image getImage(String imageName) {
        String imgname;
        String string = imgname = imageName == null ? this.defaultImage : imageName;
        if (imgname != null) {
            Image result = null;
            URL imgUrl = this.getPlugin().getBundle().getEntry(String.valueOf(this.getPathSuffix()) + imgname);
            if (imgUrl != null) {
                ImageDescriptor id = null;
                result = this.getPlugin().getImageRegistry().get(imgUrl.toExternalForm());
                if (result == null && (id = ImageDescriptor.createFromURL((URL)imgUrl)) != null) {
                    result = id.createImage();
                    this.getPlugin().getImageRegistry().put(imgUrl.toExternalForm(), result);
                }
                return result;
            }
            if (!imgname.equals(this.notFound)) {
                return this.getImage(this.notFound);
            }
        }
        return null;
    }

    public void setPathSuffix(String pathSuffix) {
        this.pathSuffix = pathSuffix;
    }

    public String getPathSuffix() {
        return this.pathSuffix;
    }

    public void setPlugin(AbstractUIPlugin plugin) {
        this.plugin = plugin;
    }

    public AbstractUIPlugin getPlugin() {
        return this.plugin;
    }

    public void setNotFound(String notFound) {
        this.notFound = notFound;
    }

    public String getNotFound() {
        return this.notFound;
    }

    public String getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(String defaultImage) {
        this.defaultImage = defaultImage;
    }
}

