/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.parsetree.util.ParsetreeSwitch;
import org.eclipse.xtext.ui.core.ILocationInFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLocationInFileProvider
implements ILocationInFileProvider {
    @Override
    public Region getLocation(EObject obj) {
        NodeAdapter adapter = NodeUtil.getNodeAdapter((EObject)obj);
        if (adapter == null) {
            if (obj.eContainer() == null) {
                return new Region(0, 0);
            }
            return this.getLocation(obj.eContainer());
        }
        List<AbstractNode> nodes = this.getLocationNodes(obj);
        if (nodes == null || nodes.isEmpty()) {
            nodes = Collections.singletonList(adapter.getParserNode());
        }
        return this.createRegion(nodes);
    }

    protected List<AbstractNode> getLocationNodes(EObject obj) {
        EStructuralFeature nameFeature = this.getIdentifierFeature(obj);
        if (nameFeature != null) {
            return NodeUtil.findNodesForFeature((EObject)obj, (EStructuralFeature)nameFeature);
        }
        ArrayList<AbstractNode> resultNodes = new ArrayList<AbstractNode>();
        NodeAdapter adapter = NodeUtil.getNodeAdapter((EObject)obj);
        CompositeNode startNode = adapter.getParserNode();
        AbstractNode keywordNode = null;
        EList children = startNode.getChildren();
        for (AbstractNode child : children) {
            EObject grammarElement = child.getGrammarElement();
            if (grammarElement instanceof RuleCall) {
                RuleCall ruleCall = (RuleCall)grammarElement;
                String ruleName = ruleCall.getRule().getName();
                if (!ruleName.equals("ID")) continue;
                resultNodes.add(child);
                continue;
            }
            if (!(grammarElement instanceof Keyword) || keywordNode != null || !this.useKeyword((Keyword)grammarElement, obj)) continue;
            keywordNode = child;
        }
        if (resultNodes.isEmpty() && keywordNode != null) {
            resultNodes.add(keywordNode);
        }
        return resultNodes;
    }

    protected boolean useKeyword(Keyword keyword, EObject context) {
        return true;
    }

    protected EStructuralFeature getIdentifierFeature(EObject obj) {
        EClass eClass = obj.eClass();
        EStructuralFeature result = eClass.getEStructuralFeature("name");
        return result != null ? result : eClass.getEStructuralFeature("id");
    }

    protected Region createRegion(List<AbstractNode> nodes) {
        OffsetCalculator calculator = this.createCalculator();
        AbstractNode firstNode = calculator.handle(nodes, true);
        AbstractNode lastNode = calculator.handle(nodes, false);
        int length = lastNode.getOffset() - firstNode.getOffset() + lastNode.getLength();
        return new Region(firstNode.getOffset(), length);
    }

    protected OffsetCalculator createCalculator() {
        return new OffsetCalculator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OffsetCalculator
    extends ParsetreeSwitch<LeafNode> {
        private boolean forward = true;

        protected OffsetCalculator() {
        }

        public LeafNode caseCompositeNode(CompositeNode object) {
            return this.handleImpl((List<AbstractNode>)object.getChildren());
        }

        public AbstractNode handle(List<AbstractNode> nodes, boolean forward) {
            this.forward = forward;
            LeafNode result = this.handleImpl(nodes);
            if (result == null) {
                result = forward ? nodes.get(0) : nodes.get(nodes.size() - 1);
            }
            return result;
        }

        public LeafNode handleImpl(List<AbstractNode> nodes) {
            if (this.forward) {
                for (AbstractNode node : nodes) {
                    LeafNode result = (LeafNode)this.doSwitch((EObject)node);
                    if (result == null) continue;
                    return result;
                }
            } else {
                int i = nodes.size() - 1;
                while (i >= 0) {
                    AbstractNode node = nodes.get(i);
                    LeafNode result = (LeafNode)this.doSwitch((EObject)node);
                    if (result != null) {
                        return result;
                    }
                    --i;
                }
            }
            return null;
        }

        public LeafNode caseLeafNode(LeafNode object) {
            if (!object.isHidden()) {
                return object;
            }
            return null;
        }
    }
}

