/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.FeatureBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TargetDefinitionPersistenceHelper {
    private static final String ROOT = "target";
    private static final String ATTR_NAME = "name";
    private static final String LOCATIONS = "locations";
    private static final String LOCATION = "location";
    private static final String ATTR_LOCATION_PATH = "path";
    private static final String ATTR_LOCATION_TYPE = "type";
    private static final String ATTR_USE_DEFAULT = "useDefault";
    private static final String INCLUDE_BUNDLES = "includeBundles";
    private static final String OPTIONAL_BUNDLES = "optionalBundles";
    private static final String ENVIRONMENT = "environment";
    private static final String OS = "os";
    private static final String WS = "ws";
    private static final String ARCH = "arch";
    private static final String NL = "nl";
    private static final String TARGET_JRE = "targetJRE";
    private static final String EXEC_ENV = "execEnv";
    private static final String JRE_NAME = "jreName";
    private static final String ARGUMENTS = "launcherArgs";
    private static final String PROGRAM_ARGS = "programArgs";
    private static final String VM_ARGS = "vmArgs";
    private static final String IMPLICIT = "implicitDependencies";
    private static final String PLUGIN = "plugin";
    private static final String PDE_INSTRUCTION = "pde";
    private static final String ATTR_ID = "id";
    private static final String INSTALLABLE_UNIT = "unit";
    private static final String REPOSITORY = "repository";
    private static final String ATTR_INCLUDE_MODE = "includeMode";
    public static final String MODE_SLICER = "slicer";
    public static final String MODE_PLANNER = "planner";
    private static final String ATTR_INCLUDE_ALL_PLATFORMS = "includeAllPlatforms";
    private static final String ATTR_OPTIONAL = "optional";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_CONFIGURATION = "configuration";
    private static final String CONTENT = "content";
    private static final String ATTR_USE_ALL = "useAllPlugins";
    private static final String PLUGINS = "plugins";
    private static final String FEATURES = "features";
    private static final String EXTRA_LOCATIONS = "extraLocations";
    private static ITargetPlatformService fTargetService;
    static /* synthetic */ Class class$0;

    public static void persistXML(ITargetDefinition definition, OutputStream output) throws CoreException, ParserConfigurationException, TransformerException, IOException {
        BundleInfo[] implicitDependencies;
        IBundleContainer[] containers;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        ProcessingInstruction instruction = doc.createProcessingInstruction(PDE_INSTRUCTION, "version=\"3.5\"");
        doc.appendChild(instruction);
        Element rootElement = doc.createElement(ROOT);
        if (definition.getName() != null) {
            rootElement.setAttribute(ATTR_NAME, definition.getName());
        }
        if ((containers = definition.getBundleContainers()) != null && containers.length > 0) {
            Element containersElement = doc.createElement(LOCATIONS);
            int i = 0;
            while (i < containers.length) {
                Element containerElement = TargetDefinitionPersistenceHelper.serializeBundleContainer(doc, (AbstractBundleContainer)containers[i]);
                containersElement.appendChild(containerElement);
                ++i;
            }
            rootElement.appendChild(containersElement);
        }
        if (definition.getOS() != null || definition.getWS() != null || definition.getArch() != null || definition.getNL() != null) {
            Element envElement = doc.createElement(ENVIRONMENT);
            if (definition.getOS() != null) {
                Element element = doc.createElement(OS);
                TargetDefinitionPersistenceHelper.setTextContent(element, definition.getOS());
                envElement.appendChild(element);
            }
            if (definition.getWS() != null) {
                Element element = doc.createElement(WS);
                TargetDefinitionPersistenceHelper.setTextContent(element, definition.getWS());
                envElement.appendChild(element);
            }
            if (definition.getArch() != null) {
                Element element = doc.createElement(ARCH);
                TargetDefinitionPersistenceHelper.setTextContent(element, definition.getArch());
                envElement.appendChild(element);
            }
            if (definition.getNL() != null) {
                Element element = doc.createElement(NL);
                TargetDefinitionPersistenceHelper.setTextContent(element, definition.getNL());
                envElement.appendChild(element);
            }
            rootElement.appendChild(envElement);
        }
        if (definition.getJREContainer() != null) {
            Element jreElement = doc.createElement(TARGET_JRE);
            IPath path = definition.getJREContainer();
            jreElement.setAttribute(ATTR_LOCATION_PATH, path.toPortableString());
            rootElement.appendChild(jreElement);
        }
        if (definition.getVMArguments() != null || definition.getProgramArguments() != null) {
            Element argElement = doc.createElement(ARGUMENTS);
            if (definition.getVMArguments() != null) {
                Element element = doc.createElement(VM_ARGS);
                TargetDefinitionPersistenceHelper.setTextContent(element, definition.getVMArguments());
                argElement.appendChild(element);
            }
            if (definition.getProgramArguments() != null) {
                Element element = doc.createElement(PROGRAM_ARGS);
                TargetDefinitionPersistenceHelper.setTextContent(element, definition.getProgramArguments());
                argElement.appendChild(element);
            }
            rootElement.appendChild(argElement);
        }
        if ((implicitDependencies = definition.getImplicitDependencies()) != null && implicitDependencies.length > 0) {
            Element implicit = doc.createElement(IMPLICIT);
            int i = 0;
            while (i < implicitDependencies.length) {
                Element plugin = doc.createElement(PLUGIN);
                plugin.setAttribute(ATTR_ID, implicitDependencies[i].getSymbolicName());
                if (implicitDependencies[i].getVersion() != null) {
                    plugin.setAttribute(ATTR_VERSION, implicitDependencies[i].getVersion());
                }
                implicit.appendChild(plugin);
                ++i;
            }
            rootElement.appendChild(implicit);
        }
        doc.appendChild(rootElement);
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(output);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, outputTarget);
    }

    public static void initFromXML(ITargetDefinition definition, InputStream input) throws CoreException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        parser.setErrorHandler(new DefaultHandler());
        Document doc = parser.parse(new InputSource(input));
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equalsIgnoreCase(ROOT)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.TargetDefinitionPersistenceHelper_0));
        }
        String name = root.getAttribute(ATTR_NAME);
        if (name.length() > 0) {
            definition.setName(name);
        }
        AbstractBundleContainer oldStylePrimaryContainer = null;
        ArrayList<IBundleContainer> bundleContainers = new ArrayList<IBundleContainer>();
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                NodeList argEntries;
                Element currentElement;
                Node entry;
                Element currentElement2;
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                if (nodeName.equalsIgnoreCase(LOCATIONS)) {
                    NodeList locations = element.getChildNodes();
                    int j = 0;
                    while (j < locations.getLength()) {
                        Element locationElement;
                        Node locationNode = locations.item(j);
                        if (locationNode.getNodeType() == 1 && (locationElement = (Element)locationNode).getNodeName().equalsIgnoreCase(LOCATION)) {
                            bundleContainers.add(TargetDefinitionPersistenceHelper.deserializeBundleContainer(locationElement));
                        }
                        ++j;
                    }
                } else if (nodeName.equalsIgnoreCase(LOCATION)) {
                    oldStylePrimaryContainer = (AbstractBundleContainer)TargetDefinitionPersistenceHelper.deserializeBundleContainer(element);
                } else if (nodeName.equalsIgnoreCase(CONTENT)) {
                    boolean useAll = Boolean.TRUE.toString().equalsIgnoreCase(element.getAttribute(ATTR_USE_ALL));
                    if (useAll) {
                        bundleContainers.add(oldStylePrimaryContainer);
                    }
                    bundleContainers.addAll(TargetDefinitionPersistenceHelper.deserializeBundleContainersFromOldStyleElement(element, oldStylePrimaryContainer, useAll));
                    if (bundleContainers.isEmpty()) {
                        bundleContainers.add(oldStylePrimaryContainer);
                    }
                } else if (nodeName.equalsIgnoreCase(ENVIRONMENT)) {
                    NodeList envEntries = element.getChildNodes();
                    int j = 0;
                    while (j < envEntries.getLength()) {
                        Node entry2 = envEntries.item(j);
                        if (entry2.getNodeType() == 1) {
                            currentElement2 = (Element)entry2;
                            if (currentElement2.getNodeName().equalsIgnoreCase(OS)) {
                                definition.setOS(TargetDefinitionPersistenceHelper.getTextContent(currentElement2));
                            } else if (currentElement2.getNodeName().equalsIgnoreCase(WS)) {
                                definition.setWS(TargetDefinitionPersistenceHelper.getTextContent(currentElement2));
                            } else if (currentElement2.getNodeName().equalsIgnoreCase(ARCH)) {
                                definition.setArch(TargetDefinitionPersistenceHelper.getTextContent(currentElement2));
                            } else if (currentElement2.getNodeName().equalsIgnoreCase(NL)) {
                                definition.setNL(TargetDefinitionPersistenceHelper.getTextContent(currentElement2));
                            }
                        }
                        ++j;
                    }
                } else if (nodeName.equalsIgnoreCase(TARGET_JRE)) {
                    String text = element.getAttribute(ATTR_LOCATION_PATH);
                    if (text.length() == 0) {
                        NodeList argEntries2 = element.getChildNodes();
                        int j = 0;
                        while (j < argEntries2.getLength()) {
                            entry = argEntries2.item(j);
                            if (entry.getNodeType() == 1) {
                                String vmName;
                                IVMInstall vmInstall;
                                currentElement = (Element)entry;
                                IPath path = null;
                                if (currentElement.getNodeName().equalsIgnoreCase(EXEC_ENV)) {
                                    IExecutionEnvironment env = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(TargetDefinitionPersistenceHelper.getTextContent(currentElement));
                                    if (env != null) {
                                        path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
                                    }
                                } else if (currentElement.getNodeName().equalsIgnoreCase(JRE_NAME) && (vmInstall = VMUtil.getVMInstall(vmName = TargetDefinitionPersistenceHelper.getTextContent(currentElement))) != null) {
                                    path = JavaRuntime.newJREContainerPath((IVMInstall)vmInstall);
                                }
                                definition.setJREContainer(path);
                            }
                            ++j;
                        }
                    } else {
                        IPath path = Path.fromPortableString((String)text);
                        definition.setJREContainer(path);
                    }
                } else if (nodeName.equalsIgnoreCase(ARGUMENTS)) {
                    argEntries = element.getChildNodes();
                    int j = 0;
                    while (j < argEntries.getLength()) {
                        Node entry3 = argEntries.item(j);
                        if (entry3.getNodeType() == 1) {
                            currentElement2 = (Element)entry3;
                            if (currentElement2.getNodeName().equalsIgnoreCase(PROGRAM_ARGS)) {
                                definition.setProgramArguments(TargetDefinitionPersistenceHelper.getTextContent(currentElement2));
                            } else if (currentElement2.getNodeName().equalsIgnoreCase(VM_ARGS)) {
                                definition.setVMArguments(TargetDefinitionPersistenceHelper.getTextContent(currentElement2));
                            }
                        }
                        ++j;
                    }
                } else if (nodeName.equalsIgnoreCase(ARGUMENTS)) {
                    argEntries = element.getChildNodes();
                    int j = 0;
                    while (j < argEntries.getLength()) {
                        Node entry4 = argEntries.item(j);
                        if (entry4.getNodeType() == 1) {
                            currentElement2 = (Element)entry4;
                            if (currentElement2.getNodeName().equalsIgnoreCase(PROGRAM_ARGS)) {
                                definition.setProgramArguments(TargetDefinitionPersistenceHelper.getTextContent(currentElement2));
                            } else if (currentElement2.getNodeName().equalsIgnoreCase(VM_ARGS)) {
                                definition.setVMArguments(TargetDefinitionPersistenceHelper.getTextContent(currentElement2));
                            }
                        }
                        ++j;
                    }
                } else if (nodeName.equalsIgnoreCase(IMPLICIT)) {
                    NodeList implicitEntries = element.getChildNodes();
                    ArrayList<BundleInfo> implicit = new ArrayList<BundleInfo>(implicitEntries.getLength());
                    int j = 0;
                    while (j < implicitEntries.getLength()) {
                        entry = implicitEntries.item(j);
                        if (entry.getNodeType() == 1 && (currentElement = (Element)entry).getNodeName().equalsIgnoreCase(PLUGIN)) {
                            String version = currentElement.getAttribute(ATTR_VERSION);
                            BundleInfo bundle = new BundleInfo(currentElement.getAttribute(ATTR_ID), version.length() > 0 ? version : null, null, -1, false);
                            implicit.add(bundle);
                        }
                        ++j;
                    }
                    definition.setImplicitDependencies(implicit.toArray(new BundleInfo[implicit.size()]));
                }
            }
            ++i;
        }
        definition.setBundleContainers(bundleContainers.toArray(new IBundleContainer[bundleContainers.size()]));
    }

    private static Element serializeBundleContainer(Document doc, AbstractBundleContainer container) throws CoreException {
        BundleInfo[] optionalBundles;
        BundleInfo[] includedBundles;
        Element containerElement = doc.createElement(LOCATION);
        if (!(container instanceof IUBundleContainer)) {
            containerElement.setAttribute(ATTR_LOCATION_PATH, container.getLocation(false));
        }
        containerElement.setAttribute(ATTR_LOCATION_TYPE, container.getType());
        if (container instanceof FeatureBundleContainer) {
            containerElement.setAttribute(ATTR_ID, ((FeatureBundleContainer)container).getFeatureId());
            String version = ((FeatureBundleContainer)container).getFeatureVersion();
            if (version != null) {
                containerElement.setAttribute(ATTR_VERSION, version);
            }
        } else if (container instanceof ProfileBundleContainer) {
            String configurationArea = ((ProfileBundleContainer)container).getConfigurationLocation();
            if (configurationArea != null) {
                containerElement.setAttribute(ATTR_CONFIGURATION, configurationArea);
            }
        } else if (container instanceof IUBundleContainer) {
            IUBundleContainer iubc = (IUBundleContainer)container;
            containerElement.setAttribute(ATTR_INCLUDE_MODE, iubc.getIncludeAllRequired() ? MODE_PLANNER : MODE_SLICER);
            containerElement.setAttribute(ATTR_INCLUDE_ALL_PLATFORMS, Boolean.toString(iubc.getIncludeAllEnvironments()));
            String[] ids = iubc.getIds();
            Version[] versions = iubc.getVersions();
            int i = 0;
            while (i < ids.length) {
                Element unit = doc.createElement(INSTALLABLE_UNIT);
                unit.setAttribute(ATTR_ID, ids[i]);
                unit.setAttribute(ATTR_VERSION, versions[i].toString());
                containerElement.appendChild(unit);
                ++i;
            }
            URI[] repositories = iubc.getRepositories();
            if (repositories != null) {
                int i2 = 0;
                while (i2 < repositories.length) {
                    Element repo = doc.createElement(REPOSITORY);
                    repo.setAttribute(LOCATION, repositories[i2].toASCIIString());
                    containerElement.appendChild(repo);
                    ++i2;
                }
            }
        }
        if ((includedBundles = container.getIncludedBundles()) != null) {
            Element included = doc.createElement(INCLUDE_BUNDLES);
            TargetDefinitionPersistenceHelper.serializeBundles(doc, included, includedBundles);
            containerElement.appendChild(included);
        }
        if ((optionalBundles = container.getOptionalBundles()) != null) {
            Element optional = doc.createElement(OPTIONAL_BUNDLES);
            TargetDefinitionPersistenceHelper.serializeBundles(doc, optional, optionalBundles);
            containerElement.appendChild(optional);
        }
        return containerElement;
    }

    private static void serializeBundles(Document doc, Element parent, BundleInfo[] bundles) {
        int j = 0;
        while (j < bundles.length) {
            Element includedBundle = doc.createElement(PLUGIN);
            includedBundle.setAttribute(ATTR_ID, bundles[j].getSymbolicName());
            String version = bundles[j].getVersion();
            if (version != null) {
                includedBundle.setAttribute(ATTR_VERSION, version);
            }
            parent.appendChild(includedBundle);
            ++j;
        }
    }

    private static IBundleContainer deserializeBundleContainer(Element location) throws CoreException {
        String def = location.getAttribute(ATTR_USE_DEFAULT);
        String path = null;
        String type = null;
        if (def.length() > 0) {
            if (Boolean.valueOf(def).booleanValue()) {
                path = "${eclipse_home}";
                type = "Profile";
            }
        } else {
            path = location.getAttribute(ATTR_LOCATION_PATH);
            type = location.getAttribute(ATTR_LOCATION_TYPE);
        }
        if (type.length() == 0) {
            type = path.endsWith(PLUGINS) ? "Directory" : "Profile";
        }
        IBundleContainer container = null;
        if ("Directory".equals(type)) {
            container = TargetDefinitionPersistenceHelper.getTargetPlatformService().newDirectoryContainer(path);
        } else if ("Profile".equals(type)) {
            String configArea = location.getAttribute(ATTR_CONFIGURATION);
            container = TargetDefinitionPersistenceHelper.getTargetPlatformService().newProfileContainer(path, configArea.length() > 0 ? configArea : null);
        } else if ("Feature".equals(type)) {
            String version = location.getAttribute(ATTR_VERSION);
            container = TargetDefinitionPersistenceHelper.getTargetPlatformService().newFeatureContainer(path, location.getAttribute(ATTR_ID), version.length() > 0 ? version : null);
        } else if ("InstallableUnit".equals(type)) {
            String includeMode = location.getAttribute(ATTR_INCLUDE_MODE);
            String includeAllPlatforms = location.getAttribute(ATTR_INCLUDE_ALL_PLATFORMS);
            NodeList list = location.getChildNodes();
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList<String> versions = new ArrayList<String>();
            ArrayList<URI> repos = new ArrayList<URI>();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() == 1) {
                    String loc;
                    Element element = (Element)node;
                    if (element.getNodeName().equalsIgnoreCase(INSTALLABLE_UNIT)) {
                        String version;
                        String id = element.getAttribute(ATTR_ID);
                        if (id.length() > 0 && (version = element.getAttribute(ATTR_VERSION)).length() > 0) {
                            ids.add(id);
                            versions.add(version);
                        }
                    } else if (element.getNodeName().equalsIgnoreCase(REPOSITORY) && (loc = element.getAttribute(LOCATION)).length() > 0) {
                        try {
                            repos.add(new URI(loc));
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                }
                ++i;
            }
            String[] iuIDs = ids.toArray(new String[ids.size()]);
            String[] iuVer = versions.toArray(new String[versions.size()]);
            URI[] uris = repos.toArray(new URI[repos.size()]);
            container = new IUBundleContainer(iuIDs, iuVer, uris);
            if (includeMode != null && includeMode.trim().length() > 0) {
                if (includeMode.equals(MODE_PLANNER)) {
                    ((IUBundleContainer)container).setIncludeAllRequired(true, null);
                } else if (includeMode.equals(MODE_SLICER)) {
                    ((IUBundleContainer)container).setIncludeAllRequired(false, null);
                }
            }
            if (includeAllPlatforms != null && includeAllPlatforms.trim().length() > 0) {
                ((IUBundleContainer)container).setIncludeAllEnvironments(Boolean.valueOf(includeAllPlatforms), null);
            }
        }
        NodeList list = location.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (element.getNodeName().equalsIgnoreCase(INCLUDE_BUNDLES)) {
                    BundleInfo[] included = TargetDefinitionPersistenceHelper.deserializeBundles(element);
                    container.setIncludedBundles(included);
                } else if (element.getNodeName().equalsIgnoreCase(OPTIONAL_BUNDLES)) {
                    BundleInfo[] optional = TargetDefinitionPersistenceHelper.deserializeBundles(element);
                    container.setOptionalBundles(optional);
                }
            }
            ++i;
        }
        return container;
    }

    private static BundleInfo[] deserializeBundles(Element bundleContainer) {
        NodeList nodes = bundleContainer.getChildNodes();
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>(nodes.getLength());
        int j = 0;
        while (j < nodes.getLength()) {
            Element includeElement;
            Node include = nodes.item(j);
            if (include.getNodeType() == 1 && (includeElement = (Element)include).getNodeName().equalsIgnoreCase(PLUGIN)) {
                String id = includeElement.getAttribute(ATTR_ID);
                String version = includeElement.getAttribute(ATTR_VERSION);
                bundles.add(new BundleInfo(id, version.length() > 0 ? version : null, null, -1, false));
            }
            ++j;
        }
        return bundles.toArray(new BundleInfo[bundles.size()]);
    }

    private static List deserializeBundleContainersFromOldStyleElement(Element content, AbstractBundleContainer primaryContainer, boolean useAll) throws CoreException {
        ArrayList<IBundleContainer> containers = new ArrayList<IBundleContainer>();
        NodeList list = content.getChildNodes();
        ArrayList<BundleInfo> included = new ArrayList<BundleInfo>(list.getLength());
        ArrayList<BundleInfo> optional = new ArrayList<BundleInfo>();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                String id;
                Node lNode;
                int j;
                Element element = (Element)node;
                if (!useAll && element.getNodeName().equalsIgnoreCase(PLUGINS)) {
                    NodeList plugins = element.getChildNodes();
                    j = 0;
                    while (j < plugins.getLength()) {
                        lNode = plugins.item(j);
                        if (lNode.getNodeType() == 1) {
                            Element plugin = (Element)lNode;
                            id = plugin.getAttribute(ATTR_ID);
                            boolean isOptional = plugin.getAttribute(ATTR_OPTIONAL).equalsIgnoreCase(Boolean.toString(true));
                            if (id.length() > 0) {
                                BundleInfo info = new BundleInfo(id, null, null, -1, false);
                                if (isOptional) {
                                    optional.add(info);
                                } else {
                                    included.add(info);
                                }
                            }
                        }
                        ++j;
                    }
                    if (included.size() > 0 || optional.size() > 0) {
                        containers.add(primaryContainer);
                    }
                } else if (element.getNodeName().equalsIgnoreCase(EXTRA_LOCATIONS)) {
                    NodeList locations = element.getChildNodes();
                    j = 0;
                    while (j < locations.getLength()) {
                        Element location;
                        String path;
                        lNode = locations.item(j);
                        if (lNode.getNodeType() == 1 && (path = (location = (Element)lNode).getAttribute(ATTR_LOCATION_PATH)).length() > 0) {
                            containers.add(TargetDefinitionPersistenceHelper.getTargetPlatformService().newDirectoryContainer(path));
                        }
                        ++j;
                    }
                } else if (!useAll && element.getNodeName().equalsIgnoreCase(FEATURES)) {
                    NodeList features = element.getChildNodes();
                    j = 0;
                    while (j < features.getLength()) {
                        Element feature;
                        lNode = features.item(j);
                        if (lNode.getNodeType() == 1 && (id = (feature = (Element)lNode).getAttribute(ATTR_ID)).length() > 0 && primaryContainer != null) {
                            containers.add(TargetDefinitionPersistenceHelper.getTargetPlatformService().newFeatureContainer(primaryContainer.getLocation(false), id, null));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (!(useAll || included.size() <= 0 && optional.size() <= 0)) {
            Iterator iterator = containers.iterator();
            while (iterator.hasNext()) {
                IBundleContainer container = (IBundleContainer)iterator.next();
                if (container instanceof FeatureBundleContainer) continue;
                if (included.size() > 0) {
                    container.setIncludedBundles(included.toArray(new BundleInfo[included.size()]));
                }
                if (optional.size() <= 0) continue;
                container.setOptionalBundles(optional.toArray(new BundleInfo[optional.size()]));
            }
        }
        return containers;
    }

    private static String getTextContent(Element element) throws DOMException {
        NodeList children = element.getChildNodes();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < children.getLength()) {
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() == 3) {
                result.append(currentNode.getNodeValue());
            }
            ++i;
        }
        return result.toString();
    }

    private static void setTextContent(Element element, String text) throws DOMException {
        Node child;
        while ((child = element.getFirstChild()) != null) {
            element.removeChild(child);
        }
        if (text != null && text.length() > 0) {
            Text textNode = element.getOwnerDocument().createTextNode(text);
            element.appendChild(textNode);
        }
    }

    private static ITargetPlatformService getTargetPlatformService() throws CoreException {
        if (fTargetService == null) {
            PDECore pDECore = PDECore.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((fTargetService = (ITargetPlatformService)pDECore.acquireService(clazz.getName())) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.TargetDefinitionPersistenceHelper_1));
            }
        }
        return fTargetService;
    }
}

