/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.TargetPlatformHelper;

public class BundleValidationOperation
implements IWorkspaceRunnable {
    private static StateObjectFactory FACTORY;
    private IPluginModelBase[] fModels;
    private Dictionary[] fProperties;
    private State fState;

    public BundleValidationOperation(IPluginModelBase[] models) {
        this(models, new Dictionary[]{TargetPlatformHelper.getTargetEnvironment()});
    }

    public BundleValidationOperation(IPluginModelBase[] models, Dictionary[] properties) {
        this.fModels = models;
        this.fProperties = properties;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (FACTORY == null) {
            FACTORY = Platform.getPlatformAdmin().getFactory();
        }
        monitor.beginTask("", this.fModels.length + 1);
        this.fState = FACTORY.createState(true);
        int i = 0;
        while (i < this.fModels.length) {
            BundleDescription bundle = this.fModels[i].getBundleDescription();
            if (bundle != null) {
                this.fState.addBundle(FACTORY.createBundleDescription(bundle));
            }
            monitor.worked(1);
            ++i;
        }
        this.fState.setPlatformProperties(this.fProperties);
        this.fState.resolve(false);
        monitor.done();
    }

    public Map getResolverErrors() {
        HashMap<BundleDescription, ResolverError[]> map = new HashMap<BundleDescription, ResolverError[]>();
        BundleDescription[] bundles = this.fState.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (!bundles[i].isResolved()) {
                map.put(bundles[i], this.fState.getResolverErrors(bundles[i]));
            }
            ++i;
        }
        return map;
    }

    public State getState() {
        return this.fState;
    }

    public boolean hasErrors() {
        return this.fState.getHighestBundleId() > -1L && this.fState.getBundles().length > this.fState.getResolvedBundles().length;
    }
}

