/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.visualizations;

import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.BranchStatement;
import de.fzi.sissy.metamod.CatchBlock;
import de.fzi.sissy.metamod.CompositeAccess;
import de.fzi.sissy.metamod.ExceptionHandler;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.JumpStatement;
import de.fzi.sissy.metamod.LoopStatement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.SimpleStatement;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.VariableAccess;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class StatementViewer {
    private DefaultListModel listModel;
    private JList list;
    private JFrame frame = new JFrame();
    private JFrame treeframe;
    private List<Function> function_vector;

    public static void main(String[] args) {
        new StatementViewer();
    }

    public StatementViewer() {
        JPanel contp = new JPanel();
        contp.setLayout(new BorderLayout());
        contp.setPreferredSize(new Dimension(300, 200));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        JScrollPane listScrollPane = new JScrollPane(this.list);
        JLabel label = new JLabel("METHODS");
        label.setFont(new Font("SansSerif", 1, 14));
        label.setHorizontalAlignment(0);
        contp.add((Component)label, "North");
        JButton button = new JButton("Show Tree");
        button.addActionListener(new buttonListener());
        contp.add((Component)button, "South");
        contp.add((Component)listScrollPane, "Center");
        this.frame.setTitle("Statement-Tree Viewer");
        this.frame.setContentPane(contp);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setVisible(true);
    }

    public void startView() {
        if (this.list.getSelectedIndex() >= 0) {
            Function function = this.function_vector.get(this.list.getSelectedIndex());
            System.out.println(String.valueOf(function.getSimpleName()) + " Index:" + this.list.getSelectedIndex());
            BlockStatement body = function.getBody();
            if (body == null) {
                System.out.println("body of Function is null");
            }
            this.generateTreeView(body, function.getSimpleName());
        }
    }

    public void showMethodSelection(List<Function> functions) {
        for (Function function : functions) {
            this.listModel.addElement(String.valueOf(function.getSimpleName()) + " LOCM: " + function.getLinesOfComments());
        }
        this.function_vector = functions;
    }

    public void generateTreeView(BlockStatement root, String func_name) {
        this.treeframe = new JFrame();
        JPanel contp = new JPanel();
        contp.setLayout(new BorderLayout());
        contp.setPreferredSize(new Dimension(500, 600));
        DefaultMutableTreeNode root_node = this.generateNode((Statement)root);
        if (root_node != null) {
            JTree tree = new JTree(root_node);
            JScrollPane treeScrollPane = new JScrollPane(tree);
            contp.add((Component)treeScrollPane, "Center");
            this.treeframe.setTitle(func_name);
            this.treeframe.setContentPane(contp);
            this.treeframe.pack();
            this.treeframe.setDefaultCloseOperation(2);
            this.treeframe.setVisible(true);
        } else {
            System.out.println("Tree was null");
        }
    }

    private DefaultMutableTreeNode createDefaultMutableTreeNode(String text) {
        String farbe = "<html><font color=#00aa00>";
        String farbeB = "</font> ";
        return new DefaultMutableTreeNode(String.valueOf(farbe) + text + farbeB);
    }

    public DefaultMutableTreeNode generateNode(Statement statement) {
        if (statement instanceof SimpleStatement) {
            DefaultMutableTreeNode node = this.createDefaultMutableTreeNode("SimpleStatement");
            node = this.addAccesses(node, statement);
            return node;
        }
        if (statement instanceof JumpStatement) {
            String typ = "";
            if (((JumpStatement)statement).isJump()) {
                typ = "jump";
            }
            if (((JumpStatement)statement).isThrow()) {
                typ = "throw";
            }
            if (((JumpStatement)statement).isReturn()) {
                typ = "return";
            }
            DefaultMutableTreeNode node = this.createDefaultMutableTreeNode("JumpStatement (" + typ + ")");
            node = this.addAccesses(node, statement);
            return node;
        }
        if (statement instanceof LoopStatement) {
            DefaultMutableTreeNode node = this.createDefaultMutableTreeNode("LoopStatement");
            if (((LoopStatement)statement).getBody() != null) {
                DefaultMutableTreeNode body_node = this.generateNode(((LoopStatement)statement).getBody());
                node.add(body_node);
            }
            node = this.addAccesses(node, statement);
            return node;
        }
        if (statement instanceof BranchStatement) {
            DefaultMutableTreeNode node = this.createDefaultMutableTreeNode("BranchStatement");
            Iterator itr = ((BranchStatement)statement).getBranches().iterator();
            while (itr.hasNext()) {
                DefaultMutableTreeNode branch_node = this.generateNode((Statement)itr.next());
                node.add(branch_node);
            }
            node = this.addAccesses(node, statement);
            return node;
        }
        if (statement instanceof ExceptionHandler) {
            DefaultMutableTreeNode node = this.createDefaultMutableTreeNode("ExceptionHandler");
            if (((ExceptionHandler)statement).getGuardedBlock() != null) {
                DefaultMutableTreeNode guarded_node = this.generateNode((Statement)((ExceptionHandler)statement).getGuardedBlock());
                node.add(guarded_node);
            }
            node = this.addAccesses(node, statement);
            Iterator itr = ((ExceptionHandler)statement).getCatchBlocks().iterator();
            while (itr.hasNext()) {
                DefaultMutableTreeNode catchblock_node = this.generateNode((Statement)((CatchBlock)itr.next()));
                node.add(catchblock_node);
            }
            if (((ExceptionHandler)statement).getFinallyBlock() != null) {
                DefaultMutableTreeNode finally_node = this.generateNode((Statement)((ExceptionHandler)statement).getFinallyBlock());
                node.add(finally_node);
            }
            node = this.addAccesses(node, statement);
            return node;
        }
        if (statement instanceof CatchBlock) {
            DefaultMutableTreeNode node = this.createDefaultMutableTreeNode("CatchBlock");
            Iterator itr = ((CatchBlock)statement).getStatements().iterator();
            while (itr.hasNext()) {
                DefaultMutableTreeNode statement_node = this.generateNode((Statement)itr.next());
                node.add(statement_node);
            }
            node = this.addAccesses(node, statement);
            return node;
        }
        if (statement instanceof BlockStatement) {
            DefaultMutableTreeNode node = this.createDefaultMutableTreeNode("BlockStatement");
            Iterator itr = ((BlockStatement)statement).getStatements().iterator();
            while (itr.hasNext()) {
                DefaultMutableTreeNode statement_node = this.generateNode((Statement)itr.next());
                node.add(statement_node);
            }
            node = this.addAccesses(node, statement);
            return node;
        }
        if (statement == null) {
            return null;
        }
        System.out.println(statement.getClass().getName());
        return null;
    }

    private DefaultMutableTreeNode addAccesses(DefaultMutableTreeNode node, Statement statement) {
        DefaultMutableTreeNode access_medi_node = this.buildAccessNodeTree(statement.getAccesses());
        if (!access_medi_node.isLeaf()) {
            node.add(access_medi_node);
        }
        node = this.addInformation(node, statement);
        return node;
    }

    private DefaultMutableTreeNode buildAccessNodeTree(ModelElementList access_list) {
        DefaultMutableTreeNode access_medi_node = new DefaultMutableTreeNode("<html><font color=#ff0000>ACCESSES</font> ");
        for (Access access : access_list) {
            CompositeAccess caccess;
            DefaultMutableTreeNode subnode;
            String text = "";
            text = access.getClass().getName();
            if (access.getAccessedTarget() != null) {
                text = String.valueOf(text) + " (Target: " + access.getAccessedTarget().getSimpleName();
            }
            text = access instanceof VariableAccess ? String.valueOf(text) + ", Write: " + (((VariableAccess)access).isWriteAccess() ? "w" : "r") + ")" : String.valueOf(text) + ")";
            DefaultMutableTreeNode access_node = new DefaultMutableTreeNode("<html><font color=#ff0000>" + text + "</font> ");
            if (access instanceof CompositeAccess && !(subnode = this.buildAccessNodeTree((caccess = (CompositeAccess)access).getAccesses())).isLeaf()) {
                access_node.add(subnode);
            }
            access_medi_node.add(access_node);
        }
        return access_medi_node;
    }

    private DefaultMutableTreeNode addInformation(DefaultMutableTreeNode node, Statement statement) {
        DefaultMutableTreeNode info_medi_node = new DefaultMutableTreeNode("<html><font color=#ff9900>INFORMATION</font> ");
        DefaultMutableTreeNode info_node = null;
        String text = null;
        text = "LOCD: " + statement.getLinesOfCode();
        text = String.valueOf(text) + " NOS: " + statement.getNumberOfStatements();
        info_node = new DefaultMutableTreeNode("<html><font color=#ff9900>" + text + "</font> ");
        info_medi_node.add(info_node);
        text = " MNL: " + statement.getMaximumNestingLevel();
        text = String.valueOf(text) + " #Edges: " + statement.getNumberOfEdgesInCFG();
        text = String.valueOf(text) + " #Nodes: " + statement.getNumberOfNodesInCFG();
        info_node = new DefaultMutableTreeNode("<html><font color=#ff9900>" + text + "</font> ");
        info_medi_node.add(info_node);
        if (!info_medi_node.isLeaf()) {
            node.add(info_medi_node);
        }
        return node;
    }

    private class buttonListener
    implements ActionListener {
        private buttonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatementViewer.this.startView();
        }
    }
}

