/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.utils;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ParsingErrorHelper
implements Runnable {
    static ParsingErrorHelper instance = null;
    static Thread t = null;
    private Date now = new Date();
    private String currentFile = "";
    BufferedReader reader;
    PipedInputStream inPipe;
    PrintStream statements;
    List<TErrorElement> elements = new ArrayList<TErrorElement>();

    public static ParsingErrorHelper getInstance() {
        if (instance == null) {
            instance = new ParsingErrorHelper();
        }
        return instance;
    }

    public void addError(String timestamp, int kindOfEror, String filename, int lineNumber, String message) {
        TErrorElement elem = new TErrorElement();
        elem.timestamp = timestamp;
        elem.kindOfError = kindOfEror;
        elem.filename = filename;
        elem.lineNumber = lineNumber;
        elem.message = message;
        this.elements.add(elem);
    }

    public Date getAnalysisTimeStamp() {
        return this.now;
    }

    public void setCurrentFile(String file) {
        this.currentFile = file;
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public void clear() {
        this.elements.clear();
    }

    public Iterator<TErrorElement> iterator() {
        return this.elements.iterator();
    }

    public void addError(String msg) {
        String text = msg;
        String filename = "";
        int line = 0;
        try {
            int a = msg.indexOf(" in file: ");
            if (a != -1) {
                text = msg.substring(0, a);
                String temp = msg.substring(a + 10);
                int b = temp.indexOf(" on line: ");
                filename = temp.substring(0, b);
                temp = temp.substring(b + 10);
                temp = temp.replace(".", "");
                temp = temp.trim();
                line = Integer.parseInt(temp);
            } else {
                a = msg.indexOf(" in FILE:");
                if (a != -1) {
                    a = msg.lastIndexOf(" @", a);
                    text = msg.substring(0, a);
                    String temp = msg.substring(a + 2);
                    int b = temp.indexOf("/");
                    String linestr = temp.substring(0, b).trim();
                    b = temp.indexOf(" in FILE:");
                    int c = temp.indexOf(" ", b);
                    filename = c > b ? temp.substring(b + 9, c).trim() : temp.substring(b + 9).trim();
                    line = Integer.parseInt(linestr);
                } else {
                    text = msg;
                }
            }
        }
        catch (Exception exception) {}
        if (filename.length() == 0) {
            filename = this.currentFile;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        String timestamp = sdf.format(this.now);
        this.addError(timestamp, 0, filename, line, text);
    }

    public PrintStream startCollectErrors() {
        try {
            this.inPipe = new PipedInputStream();
            this.reader = new BufferedReader(new InputStreamReader(this.inPipe));
            PipedOutputStream outPipe = new PipedOutputStream(this.inPipe);
            this.statements = new PrintStream(new BufferedOutputStream(outPipe));
            if (t == null) {
                t = new Thread(instance);
                t.setPriority(1);
                t.start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.statements;
    }

    public void endCollectErrors() {
        try {
            this.statements.close();
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        String line = null;
        try {
            while (true) {
                if (!this.reader.ready()) {
                    continue;
                }
                line = this.reader.readLine();
                this.addError(line);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public class TErrorElement {
        public String timestamp;
        public int kindOfError;
        public String filename;
        public int lineNumber;
        public String message;
    }
}

