/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.utils;

import de.fzi.sissy.utils.AppenderBasedStreamMonitor;
import de.fzi.sissy.utils.StreamsProxyAppender;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;

public class Log4JBasedStreamsProxy
implements IStreamsProxy {
    private AppenderBasedStreamMonitor outMonitor = null;
    private AppenderBasedStreamMonitor errMonitor = null;
    private StreamsProxyAppender myAppender = new StreamsProxyAppender();
    private ArrayList<StreamsProxyAppender> addedAppenders = new ArrayList();

    public Log4JBasedStreamsProxy() {
        this.outMonitor = new AppenderBasedStreamMonitor(Level.WARN, AppenderBasedStreamMonitor.ComparisonOperator.LESS_THAN);
        this.errMonitor = new AppenderBasedStreamMonitor(Level.WARN, AppenderBasedStreamMonitor.ComparisonOperator.GREATER_OR_EQUAL_THAN);
        this.myAppender.setLayout((Layout)new PatternLayout());
        this.addAppender(this.myAppender);
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.errMonitor;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.outMonitor;
    }

    public void write(String input) throws IOException {
        this.myAppender.doAppend(new LoggingEvent(input, null, null, (Object)input, null));
    }

    public void addAppender(StreamsProxyAppender appender) {
        this.outMonitor.addAppender(appender);
        this.errMonitor.addAppender(appender);
        this.addedAppenders.add(appender);
    }

    public void removeAppender(StreamsProxyAppender appender) {
        this.outMonitor.removeAppender(appender);
        this.errMonitor.removeAppender(appender);
        this.addedAppenders.remove((Object)appender);
    }

    public void dispose() {
        for (StreamsProxyAppender appender : this.addedAppenders) {
            this.outMonitor.removeAppender(appender);
            this.errMonitor.removeAppender(appender);
        }
        this.addedAppenders.clear();
    }
}

