/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class FileLoader {
    public static boolean exists(String path, Bundle bundle) {
        return FileLoader.exists(new File(path), bundle);
    }

    public static boolean exists(File file, Bundle bundle) {
        if (file == null) {
            throw new IllegalArgumentException("file argument is null");
        }
        boolean exists = false;
        if (file.exists()) {
            exists = true;
        } else {
            String pathx = FileLoader.convertOsToJarPath(file);
            Path path = new Path(pathx);
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
            if (url != null) {
                exists = true;
            }
        }
        return exists;
    }

    public static InputStream openAsInputStream(String path) {
        return FileLoader.openAsInputStream(new File(path), null);
    }

    public static InputStream openAsInputStream(File file, Bundle bundle) {
        if (file == null) {
            throw new IllegalArgumentException("file arument is null");
        }
        InputStream input = null;
        if (file.exists()) {
            try {
                input = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            String positionInJar = FileLoader.convertOsToJarPath(file);
            Path path = new Path(positionInJar);
            try {
                input = FileLocator.openStream((Bundle)bundle, (IPath)path, (boolean)false);
            }
            catch (IOException e) {
                e.printStackTrace();
                input = null;
            }
        }
        return input;
    }

    public static InputStreamReader openAsInputStreamReader(String path, Bundle bundle) {
        return FileLoader.openAsInputStreamReader(new File(path), bundle);
    }

    public static InputStreamReader openAsInputStreamReader(File file, Bundle bundle) {
        InputStream in = FileLoader.openAsInputStream(file, bundle);
        return in == null ? null : new InputStreamReader(in);
    }

    private static String convertOsToJarPath(File file) {
        String path = file.toString();
        return "/" + path.replace(File.separator, "/");
    }
}

