/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class Debug {
    private static int debugLevel;
    private static PrintStream out;
    private static PrintStream err;
    private static Stack streamStack;
    private static Stack debugLevelStack;
    private static Logger logger;
    private static String logfilepath;
    private static List<Appender> appenders;

    static {
        logger = Logger.getLogger((String)"de.fzi.sissy");
        appenders = new ArrayList<Appender>();
        out = System.out;
        err = System.err;
        debugLevel = 6;
        streamStack = new Stack();
        debugLevelStack = new Stack();
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        Debug.logger = logger;
    }

    public static PrintStream getOutStream() {
        return out;
    }

    public static PrintStream getErrStream() {
        return err;
    }

    public static void debug(String debugMessage) {
        logger.debug((Object)debugMessage);
    }

    public static void warning(String warningMessage) {
        if ((debugLevel & 2) != 0) {
            logger.warn((Object)warningMessage);
        }
    }

    public static void info(String infoMessage) {
        if ((debugLevel & 1) != 0) {
            logger.info((Object)infoMessage);
        }
    }

    public static void verbose(String verboseMessage) {
        if ((debugLevel & 8) != 0) {
            logger.info((Object)verboseMessage);
        }
    }

    public static void cbinfo(Object cbinfoObject) {
        if ((debugLevel & 8) != 0) {
            logger.info((Object)cbinfoObject.toString());
        }
    }

    public static void parserinfo(Object infoObject) {
        if ((debugLevel & 0x10) != 0) {
            logger.info((Object)infoObject.toString());
        }
    }

    public static void mminfo(Object o) {
        if ((debugLevel & 0x20) != 0) {
            logger.info((Object)("MetamodVisitor: " + o));
        }
    }

    public static void println(String message) {
        logger.info((Object)message);
    }

    public static void error(String errorMessage) {
        if ((debugLevel & 4) != 0) {
            logger.error((Object)("Error: " + errorMessage));
        }
    }

    public static void setDebugLevel(int newLevel) {
        if (newLevel >= 16 || newLevel < 0) {
            throw new IllegalArgumentException("newLevel value must be between 3 and 0");
        }
        debugLevel = newLevel;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void redirectOutputToWriterStream(OutputStream outs, OutputStream errs) {
        streamStack.push(out);
        streamStack.push(err);
        out = new PrintStream(outs);
        err = new PrintStream(errs);
    }

    public static void redirectOutputToFile(String outFile) {
        streamStack.push(out);
        streamStack.push(err);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(outFile);
            err = out = new PrintStream(fileOutputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            err = (PrintStream)streamStack.pop();
            out = (PrintStream)streamStack.pop();
        }
    }

    public static void redirectOutputToFile(String outFile, String errFile) {
        streamStack.push(out);
        streamStack.push(err);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(outFile);
            out = new PrintStream(fileOutputStream);
            FileOutputStream fileErrorStream = new FileOutputStream(errFile);
            err = new PrintStream(fileErrorStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            err = (PrintStream)streamStack.pop();
            out = (PrintStream)streamStack.pop();
        }
    }

    public static void redirectOutputToSystem() {
        streamStack.push(out);
        streamStack.push(err);
        out = System.out;
        err = System.err;
    }

    public static void endRedirect() {
        err = (PrintStream)streamStack.pop();
        out = (PrintStream)streamStack.pop();
    }

    public static PrintWriter getPrintWriter() {
        return new PrintWriter(out);
    }

    public static void pushDebugLevel() {
        debugLevelStack.push(new Integer(debugLevel));
    }

    public static void popDebugLevel() {
        debugLevel = (Integer)debugLevelStack.pop();
    }

    public static void clearAppenders() {
        for (Appender appender : appenders) {
            logger.removeAppender(appender);
        }
        appenders.clear();
    }

    public static void error(String message, Throwable e) {
        logger.error((Object)message, e);
    }
}

