/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui.tabs;

import de.fzi.sissy.ui.CPPHelper;
import de.fzi.sissy.ui.SWTHelper;
import de.fzi.sissy.ui.configbuilder.UIBasedSISSyConfigurationBuilder;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.AbstractConfigBuilderTab;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SISSyTab
extends AbstractConfigBuilderTab {
    private boolean shouldDisplayRunSissyOption;
    private boolean shouldDisplayAdvancedOptions;
    private HashMap<String, Widget> id2widgetMap;
    private StackLayout languageSettingsStackLayout;
    public static final String SISSY2GAST_TEXT_INPUTFILE = "sissy2gast.textinputfile";
    public static final String SISSY2GAST_OPTION_JAVA = "sissy2gast.optionjava";
    public static final String SISSY2GAST_OPTION_CPP = "sissy2gast.optioncpp";
    public static final String SISSY2GAST_OPTION_DELPHI = "sissy2gast.optiondelphi";
    public static final String SISSY2GAST_TEXT_EXPRESSIONFILE = "sissy2gast.textexpressionfile";
    public static final String SISSY2GAST_CHECK_CLONEANALYSIS = "sissy2gast.checkcloneanalysis";
    public static final String SISSY2GAST_CHECK_COMMENTS = "sissy2gast.checkcomments";
    public static final String SISSY2GAST_COMBO_SOURCELEVEL = "sissy2gast.combosourcelevel";
    public static final String SISSY2GAST_COMBO_CDTVERSION = "sissy2gast.cdtversion";
    public static final String SISSY2GAST_CHECK_OMITEXTERNC = "sissy2gast.omitexternc";
    public static final String SISSY2GAST_TEXT_LIBSRC = "sissy2gast.textlibsrc";
    public static final String SISSY2GAST_TEXT_LIBBIN = "sissy2gast.textlibbin";
    public static final String SISSY2GAST_TEXT_EXCLUDE = "sissy2gast.textexclude";
    public static final String SISSY2GAST_TEXT_INCLUDEFILE = "sissy2gast.textincludefile";
    public static final String SISSY2GAST_TEXT_DEFINITIONFILE = "sissy2gast.textdefinitionfile";
    public static final String SISSY2GAST_TABFOLDER_LANG = "sissy2gast.tabgrouplang";
    public static final String SISSY2GAST_TEXT_FREEPARAMETERS = "sissy2gast.freeparameters";
    public static final String SISSY2GAST_CHECK_EXPORT = "sissy2gast.checkexportyesno";
    public static final String SISSY2GAST_CHECK_RUNSISSY = "sissy2gast.checkrunsissy";
    public static final String SISSY2GAST_CHECK_EXTRACTCPPONLY = "sissy2gast.extractcpponly";
    private static final String SISSYGROUP = "sissy2gast.sissygroup";
    private static final String SISSYLANGUAGESETTINGS = "sissy2gast.languagegroup";
    private static final String SISSY2GAST_JAVAGROUP = "sissy2gast.javagroup";
    private static final String SISSY2GAST_CPPGROUP = "sissy2gast.cppgroup";
    private static final String SISSY2GAST_DELPHIGROUP = "sissy2gast.delphigroup";
    private static final String JAVA_SETTINGS = "Java Settings";
    private static final String C_SETTINGS = "C/C++ Settings";
    private static final String DELPHI_SETTINGS = "Delphi Settings";
    private final SelectionListener selectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            SISSyTab.this.setDirty(true);
            SISSyTab.this.updateLaunchConfigurationDialog();
        }
    };
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            SISSyTab.this.setDirty(true);
            SISSyTab.this.updateLaunchConfigurationDialog();
        }
    };

    public SISSyTab() {
        this(true, true);
    }

    public SISSyTab(boolean shouldDisplayRunSissyOption, boolean shouldDisplayAdvancedOptions) {
        this.shouldDisplayRunSissyOption = shouldDisplayRunSissyOption;
        this.shouldDisplayAdvancedOptions = shouldDisplayAdvancedOptions;
    }

    public void createControl(Composite parent) {
        this.id2widgetMap = new HashMap();
        final ScrolledComposite scrollContainer = new ScrolledComposite(parent, 2560);
        scrollContainer.setLayoutData((Object)new GridData(768, 1040));
        final Composite container = new Composite((Composite)scrollContainer, 0);
        GridLayout containerLayout = new GridLayout();
        container.setLayout((Layout)containerLayout);
        container.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                scrollContainer.setMinHeight(container.computeSize((int)-1, (int)-1).y);
            }

            public void controlMoved(ControlEvent e) {
                scrollContainer.setMinHeight(container.computeSize((int)-1, (int)-1).y);
            }
        });
        GridData containerLayoutData = new GridData(768, 1040);
        container.setLayoutData((Object)containerLayoutData);
        scrollContainer.setContent((Control)container);
        if (this.shouldDisplayRunSissyOption) {
            this.createSISSyCheckBox(container);
        }
        final Group sissyGroup = this.createSISSyGroup(container);
        if (this.shouldDisplayRunSissyOption) {
            final Button checkBoxRunSissy = (Button)this.id2widgetMap.get(SISSY2GAST_CHECK_RUNSISSY);
            checkBoxRunSissy.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    SISSyTab.this.setDirty(true);
                    SISSyTab.this.updateLaunchConfigurationDialog();
                    if (!checkBoxRunSissy.getSelection()) {
                        SWTHelper.ableControlDemo(sissyGroup, false);
                    } else {
                        SWTHelper.ableControlDemo(sissyGroup, true);
                    }
                }
            });
        }
        scrollContainer.setExpandHorizontal(true);
        scrollContainer.setMinHeight(container.computeSize((int)-1, (int)-1).y);
        scrollContainer.setExpandVertical(true);
        this.setControl((Control)scrollContainer);
    }

    private Group createSISSyGroup(Composite parentComposite) {
        Group sissyGroup = SWTHelper.addGroup(parentComposite, "SISSy Parameters");
        this.id2widgetMap.put(SISSYGROUP, (Widget)sissyGroup);
        this.createSourceInputField((Composite)sissyGroup);
        if (this.shouldDisplayAdvancedOptions) {
            this.createExportToDBCheck(sissyGroup);
        }
        this.createLanguageSelectionCombo(sissyGroup);
        this.createLanguageSettingsGroup(sissyGroup);
        this.createAdditionalParameterInputField(sissyGroup);
        return sissyGroup;
    }

    private void createAdditionalParameterInputField(Group sissyGroup) {
        Composite comp = SWTHelper.addComposite((Composite)sissyGroup);
        SWTHelper.addLabel(comp, "Other parameters");
        Text textInput = SWTHelper.addText(comp, this.modifyListener, true);
        this.id2widgetMap.put(SISSY2GAST_TEXT_FREEPARAMETERS, (Widget)textInput);
    }

    private Composite createLanguageSettingsGroup(Group sissyGroup) {
        Group langGroup = SWTHelper.addGroup((Composite)sissyGroup, "Language Settings");
        this.id2widgetMap.put(SISSYLANGUAGESETTINGS, (Widget)langGroup);
        Composite languageSettings = SWTHelper.addComposite((Composite)langGroup, 1);
        this.languageSettingsStackLayout = new StackLayout();
        languageSettings.setLayout((Layout)this.languageSettingsStackLayout);
        Composite javaComp = this.createJavaLanguageOptionsComposite(languageSettings);
        Composite cppComp = this.createCPPLanguageOptionsComposite(languageSettings);
        Composite delphiComp = this.createDelphiLanguageOptionsComposite(languageSettings);
        this.configureLanguageGroupSwitcher(javaComp, cppComp, delphiComp);
        return languageSettings;
    }

    private void createLanguageSelectionCombo(Group sissyGroup) {
        Composite comp = SWTHelper.addComposite((Composite)sissyGroup);
        SWTHelper.addLabel(comp, "Language:");
        Composite optionComp = SWTHelper.addComposite(comp);
        Button optionJava = new Button(optionComp, 16);
        optionJava.setText("java");
        Button optionCPP = new Button(optionComp, 16);
        optionCPP.setText("cpp");
        Button optionDelphi = new Button(optionComp, 16);
        optionDelphi.setText("delphi");
        this.id2widgetMap.put(SISSY2GAST_OPTION_JAVA, (Widget)optionJava);
        this.id2widgetMap.put(SISSY2GAST_OPTION_CPP, (Widget)optionCPP);
        this.id2widgetMap.put(SISSY2GAST_OPTION_DELPHI, (Widget)optionDelphi);
    }

    private void configureLanguageGroupSwitcher(final Composite javaGroup, final Composite cppGroup, final Composite delphiGroup) {
        final Group langGroup = (Group)this.id2widgetMap.get(SISSYLANGUAGESETTINGS);
        final Button optionJava = (Button)this.id2widgetMap.get(SISSY2GAST_OPTION_JAVA);
        final Button optionCPP = (Button)this.id2widgetMap.get(SISSY2GAST_OPTION_CPP);
        final Button optionDelphi = (Button)this.id2widgetMap.get(SISSY2GAST_OPTION_DELPHI);
        SelectionListener languageSwitchListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SISSyTab.this.setDirty(true);
                SISSyTab.this.updateLaunchConfigurationDialog();
                if (optionJava.getSelection()) {
                    ((SISSyTab)SISSyTab.this).languageSettingsStackLayout.topControl = javaGroup;
                    langGroup.setText(SISSyTab.JAVA_SETTINGS);
                } else if (optionCPP.getSelection()) {
                    ((SISSyTab)SISSyTab.this).languageSettingsStackLayout.topControl = cppGroup;
                    langGroup.setText(SISSyTab.C_SETTINGS);
                } else if (optionDelphi.getSelection()) {
                    ((SISSyTab)SISSyTab.this).languageSettingsStackLayout.topControl = delphiGroup;
                    langGroup.setText(SISSyTab.DELPHI_SETTINGS);
                }
            }
        };
        optionJava.addSelectionListener(languageSwitchListener);
        optionCPP.addSelectionListener(languageSwitchListener);
        optionDelphi.addSelectionListener(languageSwitchListener);
    }

    private Composite createCPPLanguageOptionsComposite(Composite languageSettings) {
        Composite cppGroup = SWTHelper.addComposite(languageSettings);
        this.id2widgetMap.put(SISSY2GAST_CPPGROUP, (Widget)cppGroup);
        this.createOmitExternCCheckbox(cppGroup);
        Composite comp = SWTHelper.addComposite(cppGroup, 5);
        this.createCDTVersionCombo(comp);
        this.createExtractCPPOnlyCheckbox(comp);
        this.createButtonFindHPPFiles(comp);
        SWTHelper.createTextAndTwoFileChooser(SISSY2GAST_TEXT_INCLUDEFILE, this.id2widgetMap, cppGroup, "File containing additional include folders (one per line):", this.modifyListener, 1, false);
        SWTHelper.createTextAndTwoFileChooser(SISSY2GAST_TEXT_DEFINITIONFILE, this.id2widgetMap, cppGroup, "File with macro configuration (each definition is a name=value pair):", this.modifyListener, 1, false);
        return cppGroup;
    }

    private Composite createDelphiLanguageOptionsComposite(Composite languageSettings) {
        Composite delphiGroup = SWTHelper.addComposite(languageSettings);
        this.id2widgetMap.put(SISSY2GAST_DELPHIGROUP, (Widget)delphiGroup);
        return delphiGroup;
    }

    private void createButtonFindHPPFiles(Composite comp) {
        Button btnFindHPPFiles = new Button(comp, 0);
        btnFindHPPFiles.setText("Find *.h and *.hpp and list directories in a file for all input paths...");
        btnFindHPPFiles.setToolTipText("A new file is being created.");
        btnFindHPPFiles.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String resultOpenFileDialog = "";
                FileDialog dialog = new FileDialog(SISSyTab.this.getShell(), 4096);
                dialog.setText("Select a File...");
                if (dialog.open() != null) {
                    resultOpenFileDialog = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName();
                }
                if (!resultOpenFileDialog.equals(new String(""))) {
                    ArrayList<String> path = new ArrayList<String>();
                    String inputPaths = ((Text)SISSyTab.this.id2widgetMap.get(SISSyTab.SISSY2GAST_TEXT_INPUTFILE)).getText();
                    String[] stringArray = inputPaths.split(";");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String pathString = stringArray[n2];
                        pathString = pathString.replace("\r", "");
                        pathString = pathString.replace("\n", "");
                        if (!(pathString = pathString.trim()).equals("")) {
                            path.add(pathString);
                        }
                        ++n2;
                    }
                    try {
                        CPPHelper.writeHPPFoldersToFile(path, resultOpenFileDialog);
                        SWTHelper.showMessageBox(SISSyTab.this.getShell(), "Success", "File successfully created.");
                        ((Text)SISSyTab.this.id2widgetMap.get(SISSyTab.SISSY2GAST_TEXT_INCLUDEFILE)).setText(resultOpenFileDialog);
                    }
                    catch (Exception exception) {
                        SWTHelper.showMessageBox(SISSyTab.this.getShell(), "Error", exception.toString());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createCDTVersionCombo(Composite comp) {
        Label label = new Label(comp, 2);
        GridData gd = new GridData();
        gd.widthHint = 20;
        gd.heightHint = 20;
        label.setLayoutData((Object)gd);
        SWTHelper.addLabel(comp, "CDT Version:");
        Combo combo = new Combo(comp, 8);
        combo.add("CDT 3");
        combo.add("CDT 6");
        this.id2widgetMap.put(SISSY2GAST_COMBO_CDTVERSION, (Widget)combo);
        combo.addSelectionListener(this.selectionListener);
        combo.select(0);
    }

    private void createExtractCPPOnlyCheckbox(Composite cppGroup) {
        Composite comp = SWTHelper.addComposite(cppGroup, 2);
        Label label = new Label(comp, 2);
        GridData gd = new GridData();
        gd.widthHint = 20;
        gd.heightHint = 20;
        label.setLayoutData((Object)gd);
        Button checkBox = new Button(comp, 16416);
        checkBox.setText("Extract only CPP files");
        checkBox.addSelectionListener(this.selectionListener);
        this.id2widgetMap.put(SISSY2GAST_CHECK_EXTRACTCPPONLY, (Widget)checkBox);
    }

    private Composite createJavaLanguageOptionsComposite(Composite languageSettings) {
        Composite javaComp = SWTHelper.addComposite(languageSettings, 1);
        this.id2widgetMap.put(SISSY2GAST_JAVAGROUP, (Widget)javaComp);
        this.createLibraryInputFields(javaComp);
        Composite comp = SWTHelper.addComposite(javaComp);
        SWTHelper.addLabel(comp, "Source level:");
        Combo combo = new Combo(comp, 8);
        combo.add("5.0");
        combo.add("1.4");
        combo.add("1.3");
        this.id2widgetMap.put(SISSY2GAST_COMBO_SOURCELEVEL, (Widget)combo);
        combo.addSelectionListener(this.selectionListener);
        combo.select(0);
        return javaComp;
    }

    private void createLibraryInputFields(Composite sissyGroup) {
        Group srcGroup = SWTHelper.addGroup(sissyGroup, "Library, Exclude");
        Composite comp = SWTHelper.addComposite((Composite)srcGroup);
        SWTHelper.addLabel(comp, "Libraries (src):");
        Text textLib = SWTHelper.addText(comp, this.modifyListener);
        this.id2widgetMap.put(SISSY2GAST_TEXT_LIBSRC, (Widget)textLib);
        comp = SWTHelper.addComposite((Composite)srcGroup);
        SWTHelper.addLabel(comp, "Libraries (bin):");
        textLib = SWTHelper.addText(comp, this.modifyListener, true);
        this.id2widgetMap.put(SISSY2GAST_TEXT_LIBBIN, (Widget)textLib);
        comp = SWTHelper.addComposite((Composite)srcGroup);
        SWTHelper.addLabel(comp, "Exclude:");
        textLib = SWTHelper.addText(comp, this.modifyListener);
        this.id2widgetMap.put(SISSY2GAST_TEXT_EXCLUDE, (Widget)textLib);
    }

    private void createAdvancedSissyOptionsCheck(Group exportGroup) {
        this.createExportToDBCheckbox(exportGroup);
        this.createExportCommentsCheckbox(exportGroup);
        this.createRunCloneAnalysisCheckbox(exportGroup);
    }

    private void createRunCloneAnalysisCheckbox(Group exportGroup) {
        Button checkBoxComment = new Button((Composite)exportGroup, 32);
        checkBoxComment.setText("Run Clone Analysis");
        checkBoxComment.addSelectionListener(this.selectionListener);
        this.id2widgetMap.put(SISSY2GAST_CHECK_CLONEANALYSIS, (Widget)checkBoxComment);
    }

    private void createExportCommentsCheckbox(Group exportGroup) {
        Button checkBoxComment = new Button((Composite)exportGroup, 32);
        checkBoxComment.setText("export the text of code comments into database");
        checkBoxComment.addSelectionListener(this.selectionListener);
        this.id2widgetMap.put(SISSY2GAST_CHECK_COMMENTS, (Widget)checkBoxComment);
    }

    private void createOmitExternCCheckbox(Composite cppGroup) {
        Button checkBoxComment = new Button(cppGroup, 32);
        checkBoxComment.setText("Omit Critical Code");
        checkBoxComment.setToolTipText("Excludes from code the following: \n1) extern \"C\" { ... } => /* extern \"C\" { */ ... /* } */ \n2) _asm { ... } => /* _asm { ... } */ \n3) typedef struct I...; => /* typedef struct I...; */ \n4) #... => //#...");
        checkBoxComment.addSelectionListener(this.selectionListener);
        this.id2widgetMap.put(SISSY2GAST_CHECK_OMITEXTERNC, (Widget)checkBoxComment);
    }

    private Group createExportToDBCheck(Group sissyGroup) {
        Group exportGroup = SWTHelper.addGroup((Composite)sissyGroup, "Export");
        this.createAdvancedSissyOptionsCheck(exportGroup);
        return exportGroup;
    }

    private void createExportToDBCheckbox(Group exportGroup) {
        Button checkBoxExport = new Button((Composite)exportGroup, 32);
        checkBoxExport.setText("export model to database");
        this.id2widgetMap.put(SISSY2GAST_CHECK_EXPORT, (Widget)checkBoxExport);
        checkBoxExport.addSelectionListener(this.selectionListener);
    }

    private void createSourceInputField(Composite parent) {
        SWTHelper.createTextAndTwoFileChooser(SISSY2GAST_TEXT_INPUTFILE, this.id2widgetMap, parent, "Input paths:", this.modifyListener, 2, true);
    }

    private Button createSISSyCheckBox(Composite container) {
        Group runsissyGroup = SWTHelper.addGroup(container, "");
        Button checkBoxRunSissy = new Button((Composite)runsissyGroup, 32);
        checkBoxRunSissy.setText("Run Extraction");
        this.id2widgetMap.put(SISSY2GAST_CHECK_RUNSISSY, (Widget)checkBoxRunSissy);
        return checkBoxRunSissy;
    }

    public String getName() {
        return "SISSy";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.initializeInputAndLanguage(configuration);
            this.initializeSources(configuration);
            this.initializeLanguageSpecifics(configuration);
            this.initializeAdvancedOptions(configuration);
            if (this.shouldDisplayRunSissyOption) {
                boolean temp3 = configuration.getAttribute(SISSY2GAST_CHECK_RUNSISSY, false);
                ((Button)this.id2widgetMap.get(SISSY2GAST_CHECK_RUNSISSY)).setSelection(temp3);
                SWTHelper.ableControlDemo((Group)this.id2widgetMap.get(SISSYGROUP), temp3);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void initializeAdvancedOptions(ILaunchConfiguration configuration) throws CoreException {
        if (this.shouldDisplayAdvancedOptions) {
            SISSyTab.initializeButton(this.id2widgetMap, configuration, SISSY2GAST_CHECK_COMMENTS);
            SISSyTab.initializeButton(this.id2widgetMap, configuration, SISSY2GAST_CHECK_CLONEANALYSIS);
            SISSyTab.initializeButton(this.id2widgetMap, configuration, SISSY2GAST_CHECK_EXPORT);
        }
    }

    private void initializeLanguageSpecifics(ILaunchConfiguration configuration) throws CoreException {
        SISSyTab.initializeText(this.id2widgetMap, configuration, SISSY2GAST_TEXT_FREEPARAMETERS);
        String sourcelevel = configuration.getAttribute(SISSY2GAST_COMBO_SOURCELEVEL, "5.0");
        ((Combo)this.id2widgetMap.get(SISSY2GAST_COMBO_SOURCELEVEL)).setText(sourcelevel);
        SISSyTab.initializeText(this.id2widgetMap, configuration, SISSY2GAST_TEXT_DEFINITIONFILE);
        SISSyTab.initializeText(this.id2widgetMap, configuration, SISSY2GAST_TEXT_INCLUDEFILE);
        String cdtversion = configuration.getAttribute(SISSY2GAST_COMBO_CDTVERSION, "CDT 3");
        ((Combo)this.id2widgetMap.get(SISSY2GAST_COMBO_CDTVERSION)).setText(cdtversion);
        SISSyTab.initializeButton(this.id2widgetMap, configuration, SISSY2GAST_CHECK_OMITEXTERNC);
        SISSyTab.initializeButton(this.id2widgetMap, configuration, SISSY2GAST_CHECK_EXTRACTCPPONLY);
    }

    private void initializeSources(ILaunchConfiguration configuration) throws CoreException {
        SISSyTab.initializeText(this.id2widgetMap, configuration, SISSY2GAST_TEXT_LIBBIN);
        SISSyTab.initializeText(this.id2widgetMap, configuration, SISSY2GAST_TEXT_LIBSRC);
        SISSyTab.initializeText(this.id2widgetMap, configuration, SISSY2GAST_TEXT_EXCLUDE);
    }

    private void initializeInputAndLanguage(ILaunchConfiguration configuration) throws CoreException {
        SISSyTab.initializeText(this.id2widgetMap, configuration, SISSY2GAST_TEXT_INPUTFILE);
        if (configuration.getAttribute(SISSY2GAST_OPTION_JAVA, false)) {
            SISSyTab.initializeButton(this.id2widgetMap, configuration, SISSY2GAST_OPTION_JAVA);
            this.languageSettingsStackLayout.topControl = (Composite)this.id2widgetMap.get(SISSY2GAST_JAVAGROUP);
            ((Group)this.id2widgetMap.get(SISSYLANGUAGESETTINGS)).setText(JAVA_SETTINGS);
        } else {
            ((Button)this.id2widgetMap.get(SISSY2GAST_OPTION_JAVA)).setSelection(false);
        }
        if (configuration.getAttribute(SISSY2GAST_OPTION_CPP, false)) {
            SISSyTab.initializeButton(this.id2widgetMap, configuration, SISSY2GAST_OPTION_CPP);
            this.languageSettingsStackLayout.topControl = (Composite)this.id2widgetMap.get(SISSY2GAST_CPPGROUP);
            ((Group)this.id2widgetMap.get(SISSYLANGUAGESETTINGS)).setText(C_SETTINGS);
        } else {
            ((Button)this.id2widgetMap.get(SISSY2GAST_OPTION_CPP)).setSelection(false);
        }
        if (configuration.getAttribute(SISSY2GAST_OPTION_DELPHI, false)) {
            SISSyTab.initializeButton(this.id2widgetMap, configuration, SISSY2GAST_OPTION_DELPHI);
            this.languageSettingsStackLayout.topControl = (Composite)this.id2widgetMap.get(SISSY2GAST_DELPHIGROUP);
            ((Group)this.id2widgetMap.get(SISSYLANGUAGESETTINGS)).setText(DELPHI_SETTINGS);
        } else {
            ((Button)this.id2widgetMap.get(SISSY2GAST_OPTION_DELPHI)).setSelection(false);
        }
    }

    public static void initializeText(HashMap<String, Widget> map, ILaunchConfiguration configuration, String key) throws CoreException {
        ((Text)map.get(key)).setText(configuration.getAttribute(key, ""));
    }

    public static void initializeButton(HashMap<String, Widget> map, ILaunchConfiguration configuration, String key) throws CoreException {
        boolean temp = configuration.getAttribute(key, false);
        ((Button)map.get(key)).setSelection(temp);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.saveGeneralValues(configuration);
        if (this.shouldDisplayRunSissyOption) {
            SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_CHECK_RUNSISSY);
        } else {
            configuration.setAttribute(SISSY2GAST_CHECK_RUNSISSY, true);
        }
        if (this.shouldDisplayAdvancedOptions) {
            SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_CHECK_COMMENTS);
            SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_CHECK_CLONEANALYSIS);
            SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_CHECK_EXPORT);
        } else {
            configuration.setAttribute(SISSY2GAST_CHECK_EXPORT, true);
            configuration.setAttribute(SISSY2GAST_CHECK_COMMENTS, false);
            configuration.setAttribute(SISSY2GAST_CHECK_CLONEANALYSIS, false);
        }
    }

    private void saveGeneralValues(ILaunchConfigurationWorkingCopy configuration) {
        SISSyTab.saveTextValue(this.id2widgetMap, configuration, SISSY2GAST_TEXT_INPUTFILE);
        SISSyTab.saveTextValue(this.id2widgetMap, configuration, SISSY2GAST_TEXT_LIBBIN);
        SISSyTab.saveTextValue(this.id2widgetMap, configuration, SISSY2GAST_TEXT_LIBSRC);
        SISSyTab.saveTextValue(this.id2widgetMap, configuration, SISSY2GAST_TEXT_EXCLUDE);
        SISSyTab.saveTextValue(this.id2widgetMap, configuration, SISSY2GAST_TEXT_DEFINITIONFILE);
        SISSyTab.saveTextValue(this.id2widgetMap, configuration, SISSY2GAST_TEXT_INCLUDEFILE);
        SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_OPTION_CPP);
        SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_OPTION_JAVA);
        SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_OPTION_DELPHI);
        SISSyTab.saveComboValue(this.id2widgetMap, configuration, SISSY2GAST_COMBO_SOURCELEVEL);
        SISSyTab.saveComboValue(this.id2widgetMap, configuration, SISSY2GAST_COMBO_CDTVERSION);
        SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_CHECK_OMITEXTERNC);
        SISSyTab.saveButtonValue(this.id2widgetMap, configuration, SISSY2GAST_CHECK_EXTRACTCPPONLY);
        SISSyTab.saveTextValue(this.id2widgetMap, configuration, SISSY2GAST_TEXT_FREEPARAMETERS);
    }

    public static void saveTextValue(HashMap<String, Widget> map, ILaunchConfigurationWorkingCopy configuration, String key) {
        configuration.setAttribute(key, ((Text)map.get(key)).getText());
    }

    private static void saveButtonValue(HashMap<String, Widget> map, ILaunchConfigurationWorkingCopy configuration, String key) {
        boolean temp = ((Button)map.get(key)).getSelection();
        configuration.setAttribute(key, temp);
    }

    private static void saveComboValue(HashMap<String, Widget> map, ILaunchConfigurationWorkingCopy configuration, String key) {
        configuration.setAttribute(key, ((Combo)map.get(key)).getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SISSY2GAST_OPTION_JAVA, true);
        configuration.setAttribute(SISSY2GAST_OPTION_CPP, false);
        configuration.setAttribute(SISSY2GAST_OPTION_DELPHI, false);
        configuration.setAttribute(SISSY2GAST_CHECK_EXPORT, true);
        configuration.setAttribute(SISSY2GAST_CHECK_RUNSISSY, true);
        configuration.setAttribute(SISSY2GAST_CHECK_COMMENTS, false);
        configuration.setAttribute(SISSY2GAST_CHECK_CLONEANALYSIS, false);
        configuration.setAttribute(SISSY2GAST_COMBO_SOURCELEVEL, "5.0");
        configuration.setAttribute(SISSY2GAST_COMBO_CDTVERSION, "CDT 3");
        configuration.setAttribute(SISSY2GAST_CHECK_OMITEXTERNC, false);
    }

    protected AbstractUIBasedConfigurationBuilder<?> getConfigurationBuilder(ILaunchConfiguration launchConfig) throws CoreException {
        return new UIBasedSISSyConfigurationBuilder(launchConfig.getAttributes());
    }
}

