/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui.tabs;

import de.fzi.sissy.metamod.Metric;
import de.fzi.sissy.metrics.MetricCalculationConfiguration;
import de.fzi.sissy.ui.SWTHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class MetricsTab
extends AbstractLaunchConfigurationTab {
    private HashMap<String, Widget> id2widgetMap;
    public static final String SISSYMETRICS_CHECK_CALCULATE_METRICS = "sissy.metrics.docalculation";
    public static final String SISSYMETRICS_TABLE_METRICS = "sissy.metrics.table";
    private static final int TYPE_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private final SelectionListener selectionListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            MetricsTab.this.setDirty(true);
            MetricsTab.this.updateLaunchConfigurationDialog();
        }
    };
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MetricsTab.this.setDirty(true);
            MetricsTab.this.updateLaunchConfigurationDialog();
        }
    };

    public MetricsTab() {
        this.id2widgetMap = new HashMap();
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollContainer = this.createAndSetupScrollcontainer(parent);
        Composite container = this.createAndSetupContainer(scrollContainer);
        this.createRunGroup(container);
        Group patternGroup = SWTHelper.addGroup(container, "Metric Calculation");
        Composite buttonComp = SWTHelper.addComposite((Composite)patternGroup);
        this.createSelectionButtons(buttonComp);
        Composite metricComp = SWTHelper.addComposite((Composite)patternGroup);
        this.createAndSetupMetricsTable(metricComp, (Button)buttonComp.getChildren()[0], (Button)buttonComp.getChildren()[1]);
        container.setSize(container.computeSize(-1, -1));
        scrollContainer.setExpandHorizontal(true);
        this.setControl((Control)scrollContainer);
    }

    private ScrolledComposite createAndSetupScrollcontainer(Composite parent) {
        ScrolledComposite scrollContainer = new ScrolledComposite(parent, 2560);
        scrollContainer.setLayoutData((Object)new GridData(768));
        return scrollContainer;
    }

    private Composite createAndSetupContainer(ScrolledComposite scrollContainer) {
        Composite container = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)container);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(768));
        return container;
    }

    private void createRunGroup(Composite container) {
        Group runGroup = SWTHelper.addGroup(container, "Run Metric Calculation");
        runGroup.setData((Object)"Metrics");
        Button checkBoxComment = new Button((Composite)runGroup, 32);
        checkBoxComment.setText("Run Metric Calculation");
        checkBoxComment.addSelectionListener(this.selectionListener);
        this.id2widgetMap.put(SISSYMETRICS_CHECK_CALCULATE_METRICS, (Widget)checkBoxComment);
    }

    private void createSelectionButtons(Composite buttcomp) {
        RowLayout rowlayout = new RowLayout();
        rowlayout.pack = false;
        buttcomp.setLayout((Layout)rowlayout);
        Button chooseAll = new Button(buttcomp, 0x1000000);
        chooseAll.setText("Select all");
        Button chooseNone = new Button(buttcomp, 0x1000000);
        chooseNone.setText("Clear selection");
    }

    private void createAndSetupMetricsTable(Composite metricsComp, Button chooseAll, Button chooseNone) {
        Table metricsTable = new Table(metricsComp, 67618);
        TableColumn tableColumn1 = new TableColumn(metricsTable, 0x1000000);
        tableColumn1.setText("Metric");
        TableColumn tableColumn2 = new TableColumn(metricsTable, 16384);
        tableColumn2.setText("Description");
        metricsTable.setLinesVisible(true);
        metricsTable.setHeaderVisible(true);
        List<Metric> metricTypes = this.initializeMetricList();
        for (Metric metricType : metricTypes) {
            TableItem item = new TableItem(metricsTable, 0);
            item.setData((Object)metricType);
            item.setText(0, metricType.getType());
            item.setText(1, metricType.getDescription());
        }
        metricsTable.addSelectionListener(this.selectionListener);
        this.id2widgetMap.put(SISSYMETRICS_TABLE_METRICS, (Widget)metricsTable);
        int column = 2;
        int i = 0;
        while (i < column) {
            metricsTable.getColumn(i).pack();
            ++i;
        }
        this.setupMouseListenersForPatternSelectionAndDeselection(chooseAll, chooseNone, metricsTable);
    }

    private void setupMouseListenersForPatternSelectionAndDeselection(Button chooseAll, Button chooseNone, final Table metricsTable) {
        chooseAll.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableItem[] tableItemArray = metricsTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(true);
                    ++n2;
                }
                MetricsTab.this.updateLaunchConfigurationDialog();
            }
        });
        chooseNone.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableItem[] tableItemArray = metricsTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
                MetricsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public String getName() {
        return "Metric Calculation";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean temp = configuration.getAttribute(SISSYMETRICS_CHECK_CALCULATE_METRICS, false);
            ((Button)this.id2widgetMap.get(SISSYMETRICS_CHECK_CALCULATE_METRICS)).setSelection(temp);
        }
        catch (CoreException coreException) {}
        try {
            if (configuration.getAttributes().get(SISSYMETRICS_TABLE_METRICS) != null) {
                List checkedFilesList = (List)configuration.getAttributes().get(SISSYMETRICS_TABLE_METRICS);
                Table metricsTable = (Table)this.id2widgetMap.get(SISSYMETRICS_TABLE_METRICS);
                if (!checkedFilesList.isEmpty()) {
                    TableItem[] tableItemArray = metricsTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(checkedFilesList.contains(item.getText(0)));
                        ++n2;
                    }
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SISSYMETRICS_CHECK_CALCULATE_METRICS, ((Button)this.id2widgetMap.get(SISSYMETRICS_CHECK_CALCULATE_METRICS)).getSelection());
        Table metricsTable = (Table)this.id2widgetMap.get(SISSYMETRICS_TABLE_METRICS);
        LinkedList<String> checkedMetricList = new LinkedList<String>();
        TableItem[] tableItemArray = metricsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                checkedMetricList.add(item.getText(0));
            }
            ++n2;
        }
        try {
            if (configuration.getAttributes().containsKey(SISSYMETRICS_TABLE_METRICS)) {
                configuration.getAttributes().remove(SISSYMETRICS_TABLE_METRICS);
            }
        }
        catch (CoreException coreException) {}
        configuration.setAttribute(SISSYMETRICS_TABLE_METRICS, checkedMetricList);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        List<Metric> checkedFilesList = this.initializeMetricList();
        LinkedList<String> initialMetricList = new LinkedList<String>();
        for (Metric metric : checkedFilesList) {
            initialMetricList.add(metric.getType());
        }
        configuration.setAttribute(SISSYMETRICS_TABLE_METRICS, initialMetricList);
    }

    private List<Metric> initializeMetricList() {
        List metrics = new MetricCalculationConfiguration().getMetricList();
        return metrics;
    }
}

