/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui.tabs;

import de.fzi.sissy.ui.SWTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GraphMLTab
extends AbstractLaunchConfigurationTab {
    private HashMap<String, Widget> id2widgetMap = new HashMap();
    public static final String SISSY2GAST_GRAPHML_CHECKBOX_CONTAINMENT = "sissy2gast.graphmlcontainment";
    public static final String SISSY2GAST_GRAPHML_CHECKBOX_FUNCTIONCALLS = "sissy2gast.graphmlfunctioncalls";
    public static final String SISSY2GAST_GRAPHML_CHECKBOX_VARIABLEACCESSES = "sissy2gast.graphmlvariableaccesses";
    public static final String SISSY2GAST_GRAPHML_CHECKBOX_INHERITANCE = "sissy2gast.graphmlinheritance";
    public static final String SISSY2GAST_GRAPHML_CHECKBOX_IMPORTS = "sissy2gast.graphmlimports";
    public static final String SISSY2GAST_GRAPHML_CHECKBOX_EXPORTSOURCEENTITIESONLY = "sissy2gast.graphmlexportsourcentitiesonly";
    public static final String SISSY2GAST_GRAPHML_LIST_ENTITIES = "sissy2gast.graphmlentitieslist";
    public static final String SISSY2GAST_GRAPHML_TEXT_PATH = "sissy2gast.graphmlpath";
    public static final String SISSY2GAST_GRAPHML_CHECKBOX_RUN = "sissy2gast.graphmlrun";
    private Button checkBoxContainment;
    private Button checkBoxFunctionCalls;
    private Button checkBoxVariableAccesses;
    private Button checkBoxInheritance;
    private Button checkBoxImports;
    private List entitiesList;
    private Button btnRemoveEntity;
    private Button checkBoxExportSourceEntitiesOnly;
    private Composite compInside;
    private Button checkboxRun;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GraphMLTab.this.setDirty(true);
            GraphMLTab.this.updateLaunchConfigurationDialog();
        }
    };
    private final SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            GraphMLTab.this.setDirty(true);
            GraphMLTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private final SelectionListener selectionListenerRunCheckBox = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            GraphMLTab.this.setEnableCompInside(GraphMLTab.this.checkboxRun.getSelection());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private final SelectionListener addButtonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            String className;
            InputDialog dlg = new InputDialog(GraphMLTab.this.getShell(), "Please enter a non-qualified class name", "Please enter a non-qualified class name", "", null);
            if (dlg.open() == 0 && (className = dlg.getValue()) != null) {
                Class c = GraphMLTab.getClassForSimpleName(className);
                if (c == null) {
                    MessageDialog.openWarning((Shell)GraphMLTab.this.getShell(), (String)"Error", (String)("Class \"" + className + "\" not found"));
                } else {
                    String[] stringArray = GraphMLTab.this.entitiesList.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        if (item.equals(className)) {
                            MessageDialog.openWarning((Shell)GraphMLTab.this.getShell(), (String)"Notification", (String)("Entity \"" + className + "\" is already contained in the list."));
                            return;
                        }
                        ++n2;
                    }
                    GraphMLTab.this.updateDialog();
                    GraphMLTab.this.entitiesList.add(className);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private SelectionListener removeButtonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (GraphMLTab.this.entitiesList.getSelectionIndex() != -1) {
                GraphMLTab.this.entitiesList.remove(GraphMLTab.this.entitiesList.getSelectionIndex());
                GraphMLTab.this.updateDialog();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public void createControl(Composite parent) {
        Composite mainComposite = this.createMainComposite(parent);
        Composite compRun = SWTHelper.createComposite(mainComposite, 1, 2, 16384);
        Group runGroup = SWTHelper.addGroup(compRun, "");
        this.checkboxRun = new Button((Composite)runGroup, 32);
        this.checkboxRun.setText("Run GraphML Export");
        this.checkboxRun.addSelectionListener(this.selectionListenerRunCheckBox);
        this.checkboxRun.addSelectionListener(this.selectionListener);
        this.id2widgetMap.put(SISSY2GAST_GRAPHML_CHECKBOX_RUN, (Widget)this.checkboxRun);
        this.compInside = SWTHelper.addComposite(mainComposite, 2);
        GridData mainContainerLayoutData = new GridData(128, 16384, false, false);
        this.compInside.setLayoutData((Object)mainContainerLayoutData);
        this.createConnectionsComposite(this.compInside);
        this.createEntitiesComposite(this.compInside);
        SWTHelper.createTextAndTwoFileChooser(SISSY2GAST_GRAPHML_TEXT_PATH, this.id2widgetMap, this.compInside, "Export to:", this.modifyListener, 1, false);
        this.setControl((Control)mainComposite);
    }

    private Composite createEntitiesComposite(Composite parent) {
        Group result = SWTHelper.addGroup(parent, "Entities");
        GridData gridData = new GridData(128, 16384, false, false);
        gridData.heightHint = 200;
        gridData.widthHint = 230;
        result.setLayoutData((Object)gridData);
        Composite twoColumn = SWTHelper.addComposite((Composite)result, 2);
        this.entitiesList = new List(twoColumn, 2560);
        GridData gdList = new GridData(4, 4, true, true);
        gdList.heightHint = 100;
        gdList.widthHint = 100;
        this.entitiesList.setLayoutData((Object)gdList);
        this.id2widgetMap.put(SISSY2GAST_GRAPHML_LIST_ENTITIES, (Widget)this.entitiesList);
        Composite twoRow = SWTHelper.addComposite(twoColumn, 1);
        this.createAddEntityButton(twoRow);
        this.checkBoxExportSourceEntitiesOnly = new Button((Composite)result, 32);
        this.checkBoxExportSourceEntitiesOnly.setText("Export source entities only");
        this.id2widgetMap.put(SISSY2GAST_GRAPHML_CHECKBOX_EXPORTSOURCEENTITIESONLY, (Widget)this.checkBoxExportSourceEntitiesOnly);
        this.checkBoxExportSourceEntitiesOnly.addSelectionListener(this.selectionListener);
        return result;
    }

    private void createAddEntityButton(Composite twoRow) {
        Button btnAddEntity = new Button(twoRow, 8);
        btnAddEntity.setText("    Add...   ");
        btnAddEntity.addSelectionListener(this.addButtonListener);
        this.btnRemoveEntity = new Button(twoRow, 8);
        this.btnRemoveEntity.setText("Remove");
        this.btnRemoveEntity.addSelectionListener(this.removeButtonListener);
    }

    private Composite createConnectionsComposite(Composite parent) {
        Group result = SWTHelper.addGroup(parent, "Connections");
        GridData gridData = new GridData(128, 16384, false, false);
        gridData.heightHint = 200;
        gridData.widthHint = 150;
        result.setLayoutData((Object)gridData);
        this.createConnectionsGroupContent((Composite)result);
        return result;
    }

    private Composite createMainComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        result.setLayout((Layout)gridLayout);
        GridData mainContainerLayoutData = new GridData(128, 128, false, false);
        result.setLayoutData((Object)mainContainerLayoutData);
        return result;
    }

    private void createConnectionsGroupContent(Composite connections) {
        Composite innerComp = SWTHelper.addComposite(connections);
        GridLayout gridLayout = new GridLayout();
        innerComp.setLayout((Layout)gridLayout);
        GridData mainContainerLayoutData = new GridData(128);
        innerComp.setLayoutData((Object)mainContainerLayoutData);
        mainContainerLayoutData.verticalIndent = 5;
        mainContainerLayoutData.horizontalIndent = 5;
        this.checkBoxContainment = new Button(innerComp, 32);
        this.checkBoxContainment.setText("Containment");
        this.id2widgetMap.put(SISSY2GAST_GRAPHML_CHECKBOX_CONTAINMENT, (Widget)this.checkBoxContainment);
        this.checkBoxContainment.addSelectionListener(this.selectionListener);
        this.checkBoxFunctionCalls = new Button(innerComp, 32);
        this.checkBoxFunctionCalls.setText("Function Calls");
        this.id2widgetMap.put(SISSY2GAST_GRAPHML_CHECKBOX_FUNCTIONCALLS, (Widget)this.checkBoxFunctionCalls);
        this.checkBoxFunctionCalls.addSelectionListener(this.selectionListener);
        this.checkBoxVariableAccesses = new Button(innerComp, 32);
        this.checkBoxVariableAccesses.setText("Variable Accesses");
        this.id2widgetMap.put(SISSY2GAST_GRAPHML_CHECKBOX_VARIABLEACCESSES, (Widget)this.checkBoxVariableAccesses);
        this.checkBoxVariableAccesses.addSelectionListener(this.selectionListener);
        this.checkBoxInheritance = new Button(innerComp, 32);
        this.checkBoxInheritance.setText("Inheritance");
        this.id2widgetMap.put(SISSY2GAST_GRAPHML_CHECKBOX_INHERITANCE, (Widget)this.checkBoxInheritance);
        this.checkBoxInheritance.addSelectionListener(this.selectionListener);
        this.checkBoxImports = new Button(innerComp, 32);
        this.checkBoxImports.setText("Imports");
        this.id2widgetMap.put(SISSY2GAST_GRAPHML_CHECKBOX_IMPORTS, (Widget)this.checkBoxImports);
        this.checkBoxImports.addSelectionListener(this.selectionListener);
    }

    public String getName() {
        return "GraphML";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.loadAllValues(this.id2widgetMap, configuration);
        try {
            this.setEnableCompInside(configuration.getAttribute(SISSY2GAST_GRAPHML_CHECKBOX_RUN, false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void loadAllValues(HashMap<String, Widget> map, ILaunchConfiguration config) {
        try {
            for (String key : map.keySet()) {
                Widget widget = map.get(key);
                if (widget instanceof Button) {
                    Button button = (Button)map.get(key);
                    button.setSelection(config.getAttribute(key, false));
                    continue;
                }
                if (widget instanceof List) {
                    List list = (List)widget;
                    list.removeAll();
                    ArrayList inputList = (ArrayList)config.getAttribute(key, new ArrayList());
                    for (String item : inputList) {
                        list.add(item);
                    }
                    continue;
                }
                if (!(widget instanceof Text)) continue;
                Text text = (Text)map.get(key);
                text.setText(config.getAttribute(key, ""));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.saveAllValues(this.id2widgetMap, configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SISSY2GAST_GRAPHML_CHECKBOX_CONTAINMENT, false);
        configuration.setAttribute(SISSY2GAST_GRAPHML_CHECKBOX_EXPORTSOURCEENTITIESONLY, false);
        configuration.setAttribute(SISSY2GAST_GRAPHML_CHECKBOX_FUNCTIONCALLS, false);
        configuration.setAttribute(SISSY2GAST_GRAPHML_CHECKBOX_IMPORTS, false);
        configuration.setAttribute(SISSY2GAST_GRAPHML_CHECKBOX_INHERITANCE, false);
        configuration.setAttribute(SISSY2GAST_GRAPHML_CHECKBOX_RUN, false);
        configuration.setAttribute(SISSY2GAST_GRAPHML_CHECKBOX_VARIABLEACCESSES, false);
        configuration.setAttribute(SISSY2GAST_GRAPHML_LIST_ENTITIES, new ArrayList());
        configuration.setAttribute(SISSY2GAST_GRAPHML_TEXT_PATH, "");
    }

    private void setEnableCompInside(boolean enable) {
        SWTHelper.ableCompositeDemo(this.compInside, enable);
    }

    final void updateDialog() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    public static Class getClassForSimpleName(String simpleName) {
        String fullName = "de.fzi.sissy.metamod." + simpleName;
        try {
            Class<?> c = Class.forName(fullName);
            return c;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void saveAllValues(HashMap<String, Widget> map, ILaunchConfigurationWorkingCopy config) {
        for (String key : map.keySet()) {
            Widget widget = map.get(key);
            if (widget instanceof Button) {
                Button button = (Button)widget;
                config.setAttribute(key, button.getSelection());
                continue;
            }
            if (widget instanceof List) {
                List list = (List)widget;
                ArrayList<String> resultList = new ArrayList<String>();
                String[] stringArray = list.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    resultList.add(item);
                    ++n2;
                }
                config.setAttribute(key, resultList);
                continue;
            }
            if (!(widget instanceof Text)) continue;
            Text text = (Text)widget;
            config.setAttribute(key, text.getText());
        }
    }
}

