/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui.configbuilder;

import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.main.configurations.SISSyConfiguration;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.ui.configbuilder.GraphMLConfigurationBuilder;
import de.fzi.sissy.ui.configbuilder.UIBasedDatabaseConfigurationBuilder;
import de.fzi.sissy.ui.configbuilder.UIBasedGASTImporterConfigurationBuilder;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UIBasedSISSyConfigurationBuilder
extends AbstractUIBasedConfigurationBuilder<SISSyConfiguration> {
    public UIBasedSISSyConfigurationBuilder(Map<String, Object> attributes) {
        super(attributes);
    }

    protected SISSyConfiguration internalBuild(Map<String, Object> attributes) {
        UIBasedDatabaseConfigurationBuilder dbConfigBuilder = new UIBasedDatabaseConfigurationBuilder(attributes);
        SISSyConfiguration sissyConfiguration = new SISSyConfiguration((DatabaseConfiguration)dbConfigBuilder.build());
        String inputPathString = (String)attributes.get("sissy2gast.textinputfile");
        List<String> inputPaths = this.convertStringToList(inputPathString);
        sissyConfiguration.getExtractorConfiguration().setRunExtraction(((Boolean)attributes.get("sissy2gast.checkrunsissy")).booleanValue());
        sissyConfiguration.getExtractorConfiguration().setInputDirectoryPaths(inputPaths);
        this.configureJavaExtraction(attributes, sissyConfiguration);
        this.configureCPPExtraction(attributes, sissyConfiguration);
        this.configureDelphiExtraction(attributes, sissyConfiguration);
        this.configureExpressionExtraction(attributes, sissyConfiguration);
        this.configureCloneAnalysis(attributes, sissyConfiguration);
        this.configureDBExport(attributes, sissyConfiguration);
        this.configureMetricCalculation(attributes, sissyConfiguration);
        this.configureProblemPatternDetectionAndDashboardGeneration(attributes, sissyConfiguration);
        this.configGraphMLExport(attributes, sissyConfiguration);
        UIBasedGASTImporterConfigurationBuilder sissy2gastConfigBuilder = new UIBasedGASTImporterConfigurationBuilder(attributes, sissyConfiguration);
        sissy2gastConfigBuilder.build();
        return sissyConfiguration;
    }

    private void configureJavaExtraction(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (((Boolean)attributes.get("sissy2gast.optionjava")).booleanValue()) {
            String exclude;
            String libSrc;
            sissyConfiguration.getExtractorConfiguration().setProgrammingLanguage(ExtractorConfiguration.ProgrammingLanguage.JAVA);
            if (attributes.get("sissy2gast.combosourcelevel") == null) {
                sissyConfiguration.getExtractorConfiguration().setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_5_0);
            } else if (attributes.get("sissy2gast.combosourcelevel").equals("5.0")) {
                sissyConfiguration.getExtractorConfiguration().setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_5_0);
            } else if (attributes.get("sissy2gast.combosourcelevel").equals("1.3")) {
                sissyConfiguration.getExtractorConfiguration().setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_1_3);
            } else if (attributes.get("sissy2gast.combosourcelevel").equals("1.4")) {
                sissyConfiguration.getExtractorConfiguration().setJavaSourceLevel(ExtractorConfiguration.JavaCodeSourceLevel.JAVA_1_4);
            }
            String libBin = (String)attributes.get("sissy2gast.textlibbin");
            if (libBin != null && !libBin.isEmpty()) {
                List<String> libBinPaths = this.convertStringToList(libBin);
                sissyConfiguration.getExtractorConfiguration().setBinaryLibraryFilePaths(libBinPaths);
            }
            if ((libSrc = (String)attributes.get("sissy2gast.textlibsrc")) != null && !libSrc.isEmpty()) {
                List<String> libSrcPaths = this.convertStringToList(libSrc);
                sissyConfiguration.getExtractorConfiguration().setSourceLibraryFilePaths(libSrcPaths);
            }
            if ((exclude = (String)attributes.get("sissy2gast.textexclude")) != null && !exclude.isEmpty()) {
                List<String> excludePaths = this.convertStringToList(exclude);
                sissyConfiguration.getExtractorConfiguration().setExcludeFilePaths(excludePaths);
            }
        }
    }

    private void configureCPPExtraction(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (((Boolean)attributes.get("sissy2gast.optioncpp")).booleanValue()) {
            sissyConfiguration.getExtractorConfiguration().setProgrammingLanguage(ExtractorConfiguration.ProgrammingLanguage.CPP);
            String defFile = (String)attributes.get("sissy2gast.textdefinitionfile");
            defFile = defFile.trim();
            if (!defFile.isEmpty()) {
                sissyConfiguration.getExtractorConfiguration().setPreprocessorDefinitionsConfigFile(defFile);
            }
            String includeFile = (String)attributes.get("sissy2gast.textincludefile");
            if (!(includeFile = includeFile.trim()).isEmpty()) {
                sissyConfiguration.getExtractorConfiguration().setIncludeDirectoriesConfigFile(includeFile);
            }
            if (attributes.get("sissy2gast.cdtversion") == null) {
                sissyConfiguration.getExtractorConfiguration().setCdtVersion(ExtractorConfiguration.CDTVersion.CDT_3);
            } else if (attributes.get("sissy2gast.cdtversion").equals("CDT 6")) {
                sissyConfiguration.getExtractorConfiguration().setCdtVersion(ExtractorConfiguration.CDTVersion.CDT_6);
            } else {
                sissyConfiguration.getExtractorConfiguration().setCdtVersion(ExtractorConfiguration.CDTVersion.CDT_3);
            }
            if (((Boolean)attributes.get("sissy2gast.omitexternc")).booleanValue()) {
                sissyConfiguration.getExtractorConfiguration().setOmitExternC(true);
            } else {
                sissyConfiguration.getExtractorConfiguration().setOmitExternC(false);
            }
            this.configureCPPOnly(attributes, sissyConfiguration);
        }
    }

    private void configureDelphiExtraction(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (((Boolean)attributes.get("sissy2gast.optiondelphi")).booleanValue()) {
            sissyConfiguration.getExtractorConfiguration().setProgrammingLanguage(ExtractorConfiguration.ProgrammingLanguage.DELPHI);
        }
    }

    private void configureExpressionExtraction(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy2gast.gastexprfilecheck") && ((Boolean)attributes.get("sissy2gast.gastexprfilecheck")).booleanValue()) {
            sissyConfiguration.getExpressionExportConfiguration().setDoExtractExpressions(true);
            sissyConfiguration.getExtractorConfiguration().setDoExtractExpressions(true);
            String expressionFilePath = (String)attributes.get("sissy2gast.gastexprfile");
            sissyConfiguration.getExpressionExportConfiguration().setExpressionFilePath(expressionFilePath);
        }
    }

    private void configureCPPOnly(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy2gast.extractcpponly")) {
            sissyConfiguration.getExtractorConfiguration().setExtractOnlyCPPFiles(((Boolean)attributes.get("sissy2gast.extractcpponly")).booleanValue());
        }
    }

    private void configureDBExport(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy2gast.checkexportyesno") && ((Boolean)attributes.get("sissy2gast.checkexportyesno")).booleanValue()) {
            sissyConfiguration.getExportConfiguration().setDoExportModel(true);
            if (attributes.containsKey("sissy2gast.checkcomments") && ((Boolean)attributes.get("sissy2gast.checkcomments")).booleanValue()) {
                sissyConfiguration.getExportConfiguration().setExportCommentTextsToDatabase(true);
            }
        }
    }

    private void configureCloneAnalysis(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy2gast.checkcloneanalysis") && ((Boolean)attributes.get("sissy2gast.checkcloneanalysis")).booleanValue()) {
            sissyConfiguration.getAnalysisConfiguration().setDoCloneAnalysis(true);
        }
    }

    private void configureMetricCalculation(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy.metrics.docalculation") && ((Boolean)attributes.get("sissy.metrics.docalculation")).booleanValue()) {
            sissyConfiguration.getMetricCalculationConfiguration().setDoMetricCalculation(true);
            this.configureMetrics(attributes, sissyConfiguration);
        }
    }

    private void configureMetrics(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy.metrics.table") && attributes.get("sissy.metrics.table") != null) {
            List selectedMetricList = (List)attributes.get("sissy.metrics.table");
            for (String metricType : selectedMetricList) {
                sissyConfiguration.getMetricCalculationConfiguration().selectMetricWithType(metricType);
            }
        }
    }

    private void configureProblemPatternDetectionAndDashboardGeneration(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy2gast.checkproblemanalysis") && ((Boolean)attributes.get("sissy2gast.checkproblemanalysis")).booleanValue()) {
            sissyConfiguration.getAnalysisConfiguration().setDoProblemPatternAnalysis(true);
            if (attributes.containsKey("sissy2gast.checkdashboardgenerator") && ((Boolean)attributes.get("sissy2gast.checkdashboardgenerator")).booleanValue()) {
                sissyConfiguration.getAnalysisConfiguration().getDashboardGeneratorConfiguration().setGenerateDashboard(true);
                String dashboardTargetPath = (String)attributes.get("sissy2gast.textdashboardgeneratortarget");
                sissyConfiguration.getAnalysisConfiguration().getDashboardGeneratorConfiguration().setDashboardTargetDirectoryPath(dashboardTargetPath);
            } else {
                sissyConfiguration.getAnalysisConfiguration().getDashboardGeneratorConfiguration().setGenerateDashboard(false);
            }
            this.configureProblemPatterns(attributes, sissyConfiguration);
            this.configureDashboardTimeLine(attributes, sissyConfiguration);
        }
    }

    private void configureProblemPatterns(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy.problempatterndetection.table") && attributes.get("sissy.problempatterndetection.table") != null) {
            List checkedFilesList = (List)attributes.get("sissy.problempatterndetection.table");
            sissyConfiguration.getAnalysisConfiguration().getQueryFilenames().addAll(checkedFilesList);
        }
    }

    private void configureDashboardTimeLine(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.get("sissy2gast.textnumberofrecords") != null) {
            String dashboardNumberOfRecords = (String)attributes.get("sissy2gast.textnumberofrecords");
            sissyConfiguration.getAnalysisConfiguration().getDashboardGeneratorConfiguration().setDashboardNumberOfRecords(dashboardNumberOfRecords);
        }
    }

    private void configGraphMLExport(Map<String, Object> attributes, SISSyConfiguration sissyConfiguration) {
        if (attributes.containsKey("sissy2gast.graphmlrun") && ((Boolean)attributes.get("sissy2gast.graphmlrun")).booleanValue()) {
            GraphMLConfigurationBuilder graphMLConfigBuilder = new GraphMLConfigurationBuilder(attributes, sissyConfiguration.getGraphMLExportConfiguration());
            graphMLConfigBuilder.build();
        }
    }

    private List<String> convertStringToList(String pathString) {
        LinkedList<String> pathList = new LinkedList<String>();
        if (pathString != null && pathString.length() > 0) {
            String[] pathArray = null;
            if (pathString.contains(";")) {
                pathArray = pathString.split(";");
            } else if (pathString.contains("\n")) {
                pathArray = pathString.split("\n");
            } else {
                pathList.add(pathString);
                return pathList;
            }
            int i = 0;
            while (i < pathArray.length) {
                pathList.add(pathArray[i].trim());
                ++i;
            }
        }
        return pathList;
    }
}

