/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui.configbuilder;

import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.persistence.config.DerbyDatabaseConfiguration;
import de.fzi.sissy.persistence.config.MysqlDatabaseConfiguration;
import de.fzi.sissy.persistence.config.NullDatabaseConfiguration;
import de.fzi.sissy.persistence.config.PostgresqlDatabaseConfiguration;
import de.fzi.sissy.persistence.config.SqliteDatabaseConfiguration;
import de.uka.ipd.sdq.workflow.launchconfig.configbuilder.AbstractUIBasedConfigurationBuilder;
import java.util.Map;

public class UIBasedDatabaseConfigurationBuilder
extends AbstractUIBasedConfigurationBuilder<DatabaseConfiguration> {
    public UIBasedDatabaseConfigurationBuilder(Map<String, Object> attributes) {
        super(attributes);
    }

    protected DatabaseConfiguration internalBuild(Map<String, Object> attributes) {
        DatabaseConfiguration.DatabaseDriver dbDriver;
        try {
            dbDriver = DatabaseConfiguration.DatabaseDriver.valueOf((String)((String)attributes.get("sissy2gast.dbdriverselection")));
        }
        catch (Exception exception) {
            dbDriver = DatabaseConfiguration.DatabaseDriver.NONE;
        }
        PostgresqlDatabaseConfiguration driver = null;
        switch (dbDriver) {
            case POSTGRESQL: {
                driver = new PostgresqlDatabaseConfiguration();
                break;
            }
            case DERBY: {
                DerbyDatabaseConfiguration derbyDriver = new DerbyDatabaseConfiguration();
                String derbyDirectoryPath = attributes.get("sissy2gast.derbyfilepath").toString().trim();
                derbyDriver.setDirectoryPath(derbyDirectoryPath);
                driver = derbyDriver;
                break;
            }
            case MYSQL: {
                driver = new MysqlDatabaseConfiguration();
                break;
            }
            case SQLITE: {
                SqliteDatabaseConfiguration sqliteDriver = new SqliteDatabaseConfiguration();
                String sqliteDirectoryPath = attributes.get("sissy2gast.sqlitefilepath").toString().trim();
                sqliteDriver.setDirectoryPath(sqliteDirectoryPath);
                driver = sqliteDriver;
                break;
            }
            default: {
                driver = new NullDatabaseConfiguration();
            }
        }
        String value = (String)attributes.get("sissy2gast.dbname");
        if (value != null && !value.trim().equals("")) {
            driver.setDatabaseName(value.trim());
        }
        if ((value = (String)attributes.get("sissy2gast.dbserverurl")) != null && !value.trim().equals("")) {
            driver.setDatabaseServerurl(value.trim());
        }
        if ((value = (String)attributes.get("sissy2gast.dbuser")) != null && !value.trim().equals("")) {
            driver.setDatabaseUsername(value.trim());
        }
        if ((value = (String)attributes.get("sissy2gast.dbpwd")) != null && !value.trim().equals("")) {
            driver.setDatabasePassword(value.trim());
        }
        return driver;
    }
}

