/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SWTHelper {
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;

    public static Button addFileSelectionButton(final Shell parent, Composite comp, final Text text) {
        Button buttonResourceTypeRepository = new Button(comp, 131072);
        buttonResourceTypeRepository.setLayoutData((Object)new GridData());
        buttonResourceTypeRepository.setText("File System...");
        buttonResourceTypeRepository.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String resultOpenFileDialog = "";
                FileDialog dialog = new FileDialog(parent, 4096);
                dialog.setText("Select a File...");
                if (dialog.open() != null) {
                    resultOpenFileDialog = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName();
                }
                if (!resultOpenFileDialog.equals(new String(""))) {
                    text.setText(resultOpenFileDialog);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        return buttonResourceTypeRepository;
    }

    public static Button addFolderSelectionButton(final Shell parent, Composite comp, final Text text) {
        Button buttonResourceTypeRepository = new Button(comp, 131072);
        buttonResourceTypeRepository.setLayoutData((Object)new GridData());
        buttonResourceTypeRepository.setText("File System...");
        buttonResourceTypeRepository.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String resultOpenFileDialog = "";
                DirectoryDialog dialog = new DirectoryDialog(parent, 4096);
                dialog.setText("Select a folder...");
                if (dialog.open() != null) {
                    resultOpenFileDialog = dialog.getFilterPath();
                }
                if (!resultOpenFileDialog.equals(new String(""))) {
                    text.setText(resultOpenFileDialog);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        return buttonResourceTypeRepository;
    }

    public static Button addWorkspaceFileSelectionButton(final Shell parent, Composite comp, final Text text) {
        Button buttonResourceTypeRepository = new Button(comp, 131072);
        buttonResourceTypeRepository.setLayoutData((Object)new GridData());
        buttonResourceTypeRepository.setText("Workspace...");
        buttonResourceTypeRepository.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IFile[] result = WorkspaceResourceDialog.openFileSelection((Shell)parent, (String)"Select File", (String)"Select File", (boolean)false, null, null);
                if (result != null && result.length > 0) {
                    text.setText(result[0].getRawLocation().toOSString());
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        return buttonResourceTypeRepository;
    }

    public static Button addWorkspaceFolderSelectionButton(final Shell parent, Composite comp, final Text text) {
        Button buttonResourceTypeRepository = new Button(comp, 131072);
        buttonResourceTypeRepository.setLayoutData((Object)new GridData());
        buttonResourceTypeRepository.setText("Workspace...");
        buttonResourceTypeRepository.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IContainer[] result = WorkspaceResourceDialog.openFolderSelection((Shell)parent, (String)"Select Folder", (String)"Select Folder", (boolean)false, null, null);
                if (result != null && result.length > 0) {
                    text.setText(result[0].getRawLocation().toOSString());
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        return buttonResourceTypeRepository;
    }

    public static Composite addComposite(Composite sissyGroup) {
        return SWTHelper.addComposite(sissyGroup, 3);
    }

    public static Composite addComposite(Composite sissyGroup, int numberofcolumns) {
        Composite comp = new Composite(sissyGroup, 0);
        comp.setLayout((Layout)new GridLayout(numberofcolumns, false));
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return comp;
    }

    public static Group addGroup(Composite container, String groupName) {
        Group group = new Group(container, 0);
        GridLayout glSissyGroup = new GridLayout(1, false);
        group.setLayout((Layout)glSissyGroup);
        group.setText(groupName);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return group;
    }

    public static Text addText(Composite comp, ModifyListener modifyListener) {
        return SWTHelper.addText(comp, modifyListener, false);
    }

    public static Text addText(Composite comp, ModifyListener modifyListener, boolean multiline) {
        Text text = null;
        text = multiline ? new Text(comp, 2818) : new Text(comp, 2052);
        GridData gd_text = new GridData(4, 0x1000000, true, false);
        if (multiline) {
            gd_text.heightHint = 75;
        }
        text.setLayoutData((Object)gd_text);
        text.addModifyListener(modifyListener);
        return text;
    }

    public static Label addLabel(Composite comp, String text) {
        Label label = new Label(comp, 0);
        label.setText(text);
        return label;
    }

    public static void disableControls(List<Control> elements) {
        for (Control control : elements) {
            control.setEnabled(false);
            if (!(control instanceof Composite)) continue;
            SWTHelper.disableComposite((Composite)control);
        }
    }

    public static void disableComposite(Composite comp) {
        Control[] children = comp.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(false);
            if (children[i] instanceof Composite) {
                SWTHelper.disableComposite((Composite)children[i]);
            }
            ++i;
        }
    }

    public static void enableComposite(Composite comp) {
        Control[] children = comp.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(true);
            if (children[i] instanceof Composite) {
                SWTHelper.enableComposite((Composite)children[i]);
            }
            ++i;
        }
    }

    public static void enableControls(List<Control> elements) {
        for (Control control : elements) {
            control.setEnabled(true);
            if (!(control instanceof Composite)) continue;
            SWTHelper.enableComposite((Composite)control);
        }
    }

    public static void ableControlDemo(Group group, boolean able) {
        group.setEnabled(able);
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                SWTHelper.ableCompositeDemo((Composite)control, able);
            }
            ++n2;
        }
    }

    public static void ableCompositeDemo(Composite composite, boolean able) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                SWTHelper.ableCompositeDemo((Composite)control, able);
            }
            control.setEnabled(able);
            ++n2;
        }
    }

    public static Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    public static Text createSingleText(Composite parent, int hspan, boolean multiline) {
        Text t = multiline ? new Text(parent, 2818) : new Text(parent, 2052);
        t.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        if (multiline) {
            gd.heightHint = 75;
        }
        t.setLayoutData((Object)gd);
        return t;
    }

    public static Composite createTextAndTwoFileChooser(String key, HashMap<String, Widget> id2widgetMap, Composite parent, String textLabel, ModifyListener modifyListener, int type, boolean multiline) {
        Composite comp = SWTHelper.createComposite(parent, 5, 5, 1808);
        GridLayout ld = (GridLayout)comp.getLayout();
        ld.marginWidth = 1;
        ld.marginHeight = 1;
        SWTHelper.addLabel(comp, textLabel);
        GridData gd = new GridData(1, 0, true, false);
        gd.horizontalSpan = 5;
        Text text = SWTHelper.createSingleText(comp, 4, multiline);
        id2widgetMap.put(key, (Widget)text);
        text.addModifyListener(modifyListener);
        SWTHelper.createButtonsComp(parent.getShell(), type, comp, text);
        return comp;
    }

    private static void createButtonsComp(Shell shell, int type, Composite comp, Text text) {
        Composite buttonsComp = SWTHelper.createComposite(comp, 3, 5, 128);
        GridLayout ld = (GridLayout)buttonsComp.getLayout();
        ld.marginHeight = 1;
        ld.marginWidth = 0;
        if (type == 1) {
            SWTHelper.addFileSelectionButton(shell, buttonsComp, text);
            SWTHelper.addWorkspaceFileSelectionButton(shell, buttonsComp, text);
        }
        if (type == 2) {
            SWTHelper.addFolderSelectionButton(shell, buttonsComp, text);
            SWTHelper.addWorkspaceFolderSelectionButton(shell, buttonsComp, text);
        }
    }

    public static void showMessageBox(Shell shell, String header, String message) {
        MessageBox m = new MessageBox(shell);
        m.setText(header);
        m.setMessage(message);
        m.open();
    }
}

