/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui;

import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.ui.JDTHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateLaunchConfigDelegate {
    private List<IProject> selectedProjects;
    private List<IFolder> selectedFolders;
    private String usedLaunchConfigurationType;
    private String usedLaunchPrefix;
    private Logger logger = Logger.getLogger((String)"de.fzi.sissy");
    private AbstractLaunchConfigurationTab helperWeightTab;

    public CreateLaunchConfigDelegate(String usedLaunchConfigurationType, String usedLaunchPrefix, AbstractLaunchConfigurationTab wTab) {
        this.usedLaunchConfigurationType = usedLaunchConfigurationType;
        this.usedLaunchPrefix = usedLaunchPrefix;
        this.helperWeightTab = wTab;
    }

    public void run(IAction action) {
        if (this.selectedProjects != null && !this.selectedProjects.isEmpty() || this.selectedFolders != null && !this.selectedFolders.isEmpty()) {
            String srcFolders = this.getSourceFolders();
            String libs = JDTHelper.composeToString(JDTHelper.extractRequiredJavaLibraries(this.selectedProjects), true, true);
            this.logger.debug((Object)("libs: " + libs));
            String projectName = this.selectedProjects.size() == 0 ? this.selectedFolders.get(0).getProject().getName() : this.selectedProjects.get(0).getName();
            String newConfigName = this.createLaunchConfiguration(this.usedLaunchPrefix, projectName, srcFolders, libs, this.usedLaunchConfigurationType);
            this.openLaunchConfiguration(newConfigName);
        }
    }

    private String getSourceFolders() {
        String srcFolders = JDTHelper.composeToString(JDTHelper.extractSourceFoldersFromJavaProjects(this.selectedProjects), true, true);
        this.logger.debug((Object)("src: " + srcFolders));
        srcFolders = String.valueOf(srcFolders) + (srcFolders == null || srcFolders.isEmpty() ? "" : "\n");
        srcFolders = String.valueOf(srcFolders) + this.foldersToString(this.selectedFolders);
        for (IProject project : this.selectedProjects) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) continue;
                srcFolders = String.valueOf(srcFolders) + project.getLocation().toOSString() + ";\n";
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return srcFolders;
    }

    private String foldersToString(List<IFolder> folders) {
        StringBuffer buffer = new StringBuffer();
        for (IFolder folder : folders) {
            buffer.append(folder.getLocation().toOSString());
            if (folders.size() <= 0) continue;
            buffer.append(";\n");
        }
        System.out.println(buffer.toString());
        return buffer.toString();
    }

    private String createLaunchConfiguration(String prefixNewConfig, String projectName, String srcFolders, String libs, String launchTypeID) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(launchTypeID);
        ILaunchConfigurationWorkingCopy workingCopy = null;
        String newConfigName = null;
        try {
            newConfigName = manager.generateUniqueLaunchConfigurationNameFrom(String.valueOf(prefixNewConfig) + projectName);
            workingCopy = type.newInstance(null, newConfigName);
            workingCopy.setAttribute("sissy2gast.textinputfile", srcFolders);
            workingCopy.setAttribute("sissy2gast.textlibbin", libs);
            workingCopy.setAttribute("sissy2gast.optionjava", true);
            workingCopy.setAttribute("sissy2gast.optioncpp", false);
            workingCopy.setAttribute("sissy2gast.optiondelphi", false);
            workingCopy.setAttribute("sissy2gast.checkrunsissy", true);
            workingCopy.setAttribute("sissy2gast.checkexportyesno", true);
            workingCopy.setAttribute("sissy2gast.combosourcelevel", "5.0");
            if (this.helperWeightTab != null) {
                this.helperWeightTab.setDefaults(workingCopy);
            }
            workingCopy.setAttribute("sissy2gast.derbyfilepath", String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocationURI().getRawPath()) + "/DerbyDB");
            workingCopy.setAttribute("sissy2gast.dbname", newConfigName);
            workingCopy.setAttribute("sissy2gast.dbpwd", "sissy");
            workingCopy.setAttribute("sissy2gast.dbuser", "sissy");
            workingCopy.setAttribute("sissy2gast.dbdriverselection", DatabaseConfiguration.DatabaseDriver.DERBY.name());
            workingCopy.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return newConfigName;
    }

    private void openLaunchConfiguration(String newConfigName) {
        if (newConfigName != null && !newConfigName.equals("")) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration configurationToOpen = this.getConfigToOpen(manager, newConfigName);
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)configurationToOpen), (String)"org.eclipse.debug.ui.launchGroup.run");
        }
    }

    private ILaunchConfiguration getConfigToOpen(ILaunchManager manager, String newConfigName) {
        ILaunchConfiguration configurationToOpen = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equals(newConfigName)) {
                    configurationToOpen = config;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return configurationToOpen;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        this.selectedProjects = new ArrayList<IProject>();
        this.selectedFolders = new ArrayList<IFolder>();
        for (Object partSelection : structuredSelection.toList()) {
            if (partSelection instanceof IJavaProject) {
                this.selectedProjects.add(((IJavaProject)partSelection).getProject());
                continue;
            }
            if (partSelection instanceof IProject) {
                this.selectedProjects.add((IProject)partSelection);
                continue;
            }
            if (!(partSelection instanceof IFolder)) continue;
            this.selectedFolders.add((IFolder)partSelection);
        }
    }
}

