/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CPPHelper {
    public static void writeHPPFoldersToFile(List<String> path, String file) throws IOException {
        Set<String> result = CPPHelper.getAllFoldersWithIncludeFiles(path);
        CPPHelper.writeSetToFile(result, file);
    }

    public static void writeSetToFile(Set<String> set, String path) throws IOException {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        if (new File(path).exists()) {
            throw new IOException("File Exists");
        }
        File file = new File(path);
        String parent = file.getParent();
        new File(parent).mkdirs();
        new File(path).createNewFile();
        FileWriter fWriter = new FileWriter(path);
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        for (String string : list) {
            bWriter.write(string);
            bWriter.newLine();
        }
        bWriter.close();
    }

    public static void main(String[] args) {
    }

    public static Set<String> getAllFoldersWithIncludeFiles(List<String> paths) {
        HashSet<String> result = new HashSet<String>();
        for (String path : paths) {
            CPPHelper.collectHelper(new File(path), result);
        }
        return result;
    }

    private static void collectHelper(File dir, Set<String> result) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File subDir = fileArray[n2];
            if (subDir.isDirectory()) {
                CPPHelper.collectHelper(subDir, result);
            } else if (subDir.isFile() && CPPHelper.fileExtension(subDir.getName()).equals("h") | CPPHelper.fileExtension(subDir.getName()).equals("hpp") && !result.contains(subDir)) {
                result.add(subDir.getParent());
            }
            ++n2;
        }
    }

    public static String fileExtension(String name) {
        if (name.contains(".")) {
            int pos = name.lastIndexOf(".");
            return name.substring(pos + 1);
        }
        return "";
    }
}

