/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

create table VKnowsRel as 

select distinct 
	res.classId, 
	res.className,
	res.knownClassId, 
	res.knownClassName,
	res.isStatic
from 
	(
	/* Type accesses including declaration type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		con.name = 'TYPEACCESS_STATIC' as IsStatic
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls, 
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = knowncls.id
		
	union

	/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		con.name = 'TYPEACCESS_STATIC' as IsStatic
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
	union


	
	/* Accesses to members */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		dm.isStatic = 1 as IsStatic
	from	
		TTypes as cls, 
		TAccesses acc, 
		TMembers as dm, 
		TTypes knowncls
	where	
		cls.id = acc.classId and
		acc.targetId = dm.id and
		dm.classId = knowncls.id
	) as res, 
	TTypes as types, 
	TConstants as c
where	
	res.classId != res.knownClassId and
	res.knownClassId = types.id and
	types.kindOfType = c.value and
	(c.name like '%CLASS' or 
		c.name like '%INTERFACE')
;


SELECT DISTINCT
	child.fullName AS subclass_name, 
	parent.fullName AS superclass_name,
	childFile.pathname AS subclass_file_name,
	childSource.startline as subclass_line_number,
	parentFile.pathname AS superclass_file_name,
	parentSource.startline as superclass_line_number
FROM 
	TTypes child, 
	TTypes parent, 
	VKnowsRel vKnowsRel, 
	TInheritances i,
	TSourceEntities childSource,
	TSourceEntities parentSource,
	TFiles childFile,
	TFiles parentFile,
	TModelElements mChild,
	TModelElements mParent,
	TConstants cmChild,
	TConstants cmParent
WHERE 
	mChild.id = child.id 
	AND mChild.status = cmChild.value
	AND cmChild.name = 'STATUS_NORMAL'
	AND mParent.id = parent.id 
	AND mParent.status = cmParent.value
	AND cmParent.name = 'STATUS_NORMAL'
	AND i.classId = child.id AND 
	i.superId = parent.id AND
	vknowsRel.classId = parent.id AND 
	vknowsRel.knownClassId = child.id AND
	/* auch statische Abhngigkeiten sollten bercksichtigt werden */
	/* vknowsRel.isStatic = false AND */
	childSource.id = child.id AND
	parentSource.id = parent.id AND
	childfile.id = childsource.sourcefileid AND
	parentfile.id = parentsource.sourcefileid
;



DROP TABLE VKnowsRel;
