/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

select
	null as package_name,
	null as class_name,
	c.name as element_type,
	f.pathName as element_name,
	length(substring(f.pathName from '[\\\\/][a-zA-Z0-9\\_]*\\.')) - 2 as element_name_length
from
	TFiles f inner join
	TModelElements mF on (f.id = mF.id) join
	TConstants mCon on (mCon.value = mF.status and mCon.name = 'STATUS_NORMAL') join
	TConstants c on c.value = f.kindOfFile and
		(length(substring(f.pathName from '[\\\\/][a-zA-Z0-9\\_]*\\.')) > 52 or
			length(substring(f.pathName from '[\\\\/][a-zA-Z0-9\\_]*\\.')) < 4)
	
union

select
	p.fullName as package_name,
	t.name as class_name,
	c.name as element_type,
	e.name as element_name,
	length(e.name) as element_name_length
from
	TModelElements e inner join
	TConstants mCon on (mCon.value = e.status and mCon.name = 'STATUS_NORMAL') join
	TSourceEntities sourceEntities on (e.id = sourceEntities.id) join
	TFiles files on (sourceEntities.sourcefileid = files.id) join
	TConstants c on c.value = e.kindOfElement and
			(c.name like 'PACK_' or
			c.name like 'TYPE_%INTERFACE' or
			c.name like 'TYPE_%CLASS' or
			c.name like 'TYPE_%DELEGATE' or
			c.name like 'FUNC_METHOD' or
			c.name like 'FUNC_GLOBALFUNC' or
			c.name like 'FUNC_GENERIC' or
			c.name like 'VAR_PROPERTY' or
			c.name like 'VAR_FIELD' or
			c.name like 'VAR_GLOBALVAR') and
		(length(e.name) > 50 or
			(length(e.name) > 0 AND length(e.name) < 2))  left outer join
	TTypes t on e.parentId = t.id left outer join
	TPackages p on e.parentId = p.id or 
		t.packageId = p.id

UNION

select
	p.fullName as package_name,
	t.name as class_name,
	c.name as element_type,
	e.name as element_name,
	length(e.name) as element_name_length
from
	TModelElements e inner join
	TConstants mCon on (mCon.value = e.status and mCon.name = 'STATUS_NORMAL') join
	TConstants c on c.value = e.kindOfElement and
			c.name like 'PACK_%' and
			(length(e.name) > 50 or
			(length(e.name) > 0 AND length(e.name) < 2))  left outer join
	TTypes t on e.parentId = t.id left outer join
	TPackages p on e.parentId = p.id or 
		t.packageId = p.id


;

