/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE TABLE VFileImportsFileCPP AS
select 
	f.id as fileid,
	f.pathname as filename,
	f2.id as knownfileid,
	f2.pathname as knownfilename
from
	TFiles f join
	TModelElements m on (f.id = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join	
	TImports imp on (imp.fileid = f.id) join
	TFiles f2 on (imp.targetid = f2.id) join
	TModelElements m2 on (f2.id = m2.id) join
	TConstants cm2 on (cm2.value = m2.status and cm2.name = 'STATUS_NORMAL') 	
where
	f.id <> f2.id
	
;


CREATE TABLE VFileImportsFileJAVA AS
select 
	f.id as fileid,
	f.pathname as filename,
	f2.id as knownfileid,
	f2.pathname as knownfilename
from
	TFiles f join
	TModelElements m on (f.id = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join	
	TImports imp on (imp.fileid = f.id) join
	TTypes type on (imp.targetid = type.id) join
	TSourceEntities s on (s.id = type.id) join
	TFiles f2 on (s.sourcefileid = f2.id) join
	TModelElements m2 on (f2.id = m2.id) join
	TConstants cm2 on (cm2.value = m2.status and cm2.name = 'STATUS_NORMAL') 	
where
	f.id <> f2.id
	
;

create table VKnowsRel as 

select distinct 
	res.classId, 
	res.className,
	res.knownClassId, 
	res.knownClassName,
	res.isStatic
from 
	(
	/* Type accesses including declaration type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		con.name = 'TYPEACCESS_STATIC' as IsStatic
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls, 
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = knowncls.id
		
	union

	/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		con.name = 'TYPEACCESS_STATIC' as IsStatic
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
	union
	
	/* Accesses to members */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		dm.isStatic = 1 as IsStatic
	from	
		TTypes as cls, 
		TAccesses acc, 
		TMembers as dm, 
		TTypes knowncls
	where	
		cls.id = acc.classId and
		acc.targetId = dm.id and
		dm.classId = knowncls.id
	) as res, 
	TTypes as types, 
	TConstants as c
where	
	res.classId != res.knownClassId and
	res.knownClassId = types.id and
	types.kindOfType = c.value and
	(c.name like '%CLASS' or 
		c.name like '%INTERFACE')
;

create table VFileKnowsFileByClass as
select
	sourceFile.id as fileid,
	sourceFile.pathname as filename,
	targetFile.id as knownfileid,
	targetFile.pathname as knownfilename
from
	VKnowsRel knows,
	TSourceEntities source,
	TFiles	sourceFile,
	TSourceEntities target,
	TFiles targetFile
where
	knows.classid = source.id
	AND source.sourcefileid = sourceFile.id
	AND knows.knownClassid = target.id
	AND target.sourcefileid = targetFile.id
;

/* Datei benutzt andere Datei ber globale Funktionen oder Variablen */

create table VGlobalDeps as
Select 
	acFile.id as fileid,
	acFile.pathname as filename,
	funcFile.id as knownfileid,
	funcFile.pathname as knownfilename
FROM
	TAccesses ac,
	TFunctions accessedFunction,
	TSourceEntities acSource,
	TFiles	acFile,
	TSourceEntities funcSource,
	TFiles funcFile
WHERE
	ac.targetid = accessedFunction.id
	AND accessedFunction.classid = -1
	AND ac.sourceid = acSource.id
	AND acSource.sourcefileid = acFile.id
	AND funcSource.id = accessedFunction.id
	AND funcSource.sourcefileid = funcFile.id

UNION

Select 
	acFile.id as fileid,
	acFile.pathname as filename,
	varFile.id as knownfileid,
	varFile.pathname as knownfilename
FROM
	TAccesses ac,
	TVariables accessedVariable,
	TConstants con,
	TSourceEntities acSource,
	TFiles	acFile,
	TSourceEntities varSource,
	TFiles varFile
WHERE
	con.value = accessedVariable.kindofvariable
	AND con.name = 'VAR_GLOBALVAR'
	AND ac.targetid = accessedVariable.id
	AND ac.sourceid = acSource.id
	AND acSource.sourcefileid = acFile.id
	AND varSource.id = accessedVariable.id
	AND varSource.sourcefileid = varFile.id

;


CREATE TABLE TFileKnowsFile as

SELECT * FROM VFileKnowsFileByClass
	UNION
SELECT * FROM 	VGlobalDeps
	UNION
SELECT * FROM 	VFileImportsFileJAVA
	UNION
SELECT * FROM 	VFileImportsFileJAVA
	
;


SELECT
	one.filename as file_name_1,
	one.knownfilename as file_name_2
FROM
	TFileKnowsFile one,
	TFileKnowsFile two,
	TModelElements mOne,
	TConstants cmOne
WHERE
	mOne.id = one.fileid
	AND cmOne.value = mOne.status
	AND cmOne.name = 'STATUS_NORMAL'
	AND one.fileid = two.knownfileid
	AND two.fileid = one.knownfileid
	AND one.fileid < two.fileid
;

DROP TABLE VFileImportsFileCPP;
DROP TABLE TFileKnowsFile;
DROP table VFileKnowsFileByClass;
DROP TABLE VKnowsRel;
DROP TABLE VGlobalDeps;
DROP TABLE VFileImportsFileJAVA;
