/* $Id: RefusedBequestImplementation.sql,v 1.1 2010/04/19 16:31:52 stammel Exp $ */
/* FZI Forschungszentrum Informatik */

CREATE TABLE VMethodOverrides(
	SubClassId INTEGER,
	SubClassFullName VARCHAR(1024),
	OverrideMethodId INTEGER,
	OverrideMethodName VARCHAR(256),
	SuperClassId INTEGER,
	SuperClassFullName VARCHAR(1024),
	OverridenMethodId INTEGER,
	OverridenMethodName VARCHAR(256))
;

INSERT INTO VMethodOverrides (SubClassId, SubClassFullName, OverrideMethodId, OverrideMethodName, SuperClassId,
SuperClassFullName, OverridenMethodId, OverridenMethodName)
SELECT
	A.id,
	A.fullname,
	FA.id,
	FA.name,
	B.id,
	B.fullname,
	FB.id,
	FB.name
FROM
	TTypes AS A join
	TModelElements AS mA on (mA.id = a.id) join
	TConstants AS cmA on (cmA.value = mA.status AND cmA.name = 'STATUS_NORMAL') join
	TMembers AS A_Am on (A_Am.classID = A.id) join
	TFunctions AS FA on (FA.id = A_Am.id AND FA.NumberOfStatements > 0) join
	TMembers AS B_Bm on (B_Bm.id = A_Am.overridenmemberid) join
	TTypes AS B on (B.id = B_Bm.classID) join
	TFunctions AS FB on (FB.id = B_Bm.id AND FB.NumberOfStatements > 0) join
	TModelElements AS mB on (mB.id = b.id) join
	TConstants AS cmB on (cmB.value = mB.status AND cmB.name = 'STATUS_NORMAL') join
	TConstants AS visibility on (visibility.value = B_Bm.visibility
AND (
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR
		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)
))

EXCEPT

SELECT
	A.id as SubClassId,
	A.fullname as SubClassFullName,
	FA.id as OverrideMethodId,
	FA.name as OverrideMethodName,
	B.id as SuperClassId,
	B.fullname as SuperClassFullName,
	FB.id as OverridenMethodId,
	FB.name as OverridenMethodName
FROM
	TTypes AS A join
	TModelElements AS mA on (mA.id = a.id) join
	TConstants AS cmA on (cmA.value = mA.status AND cmA.name = 'STATUS_NORMAL') join
	TMembers AS A_Am on (A_Am.classID = A.id) join
	TFunctions AS FA on (FA.id = A_Am.id) join
	TMembers AS B_Bm on (B_Bm.id = A_Am.overridenmemberid) join
	TTypes AS B on (B.id = B_Bm.classID) join
	TFunctions AS FB on (FB.id = B_Bm.id) join
	TModelElements AS mB on (mB.id = b.id) join
	TConstants AS cmB on (cmB.value = mB.status AND cmB.name = 'STATUS_NORMAL') join
	TAccesses AS accesses on (accesses.targetid = FB.id AND accesses.functionid = FA.id) join
	TConstants AS visibility on (visibility.value = B_Bm.visibility
AND 	(
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR
	
		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)
			
	))
;

CREATE TABLE VMethodsPerClass(
	TypeId INTEGER,
	TypeName VARCHAR(1024),
	numberOfMethods INTEGER)
;

INSERT INTO VMethodsPerClass (TypeId, TypeName, numberOfMethods)
/* Wie viele Methoden haben die Klassen, die vererbt werden, Konstruktoren und Desktruktoren werden nicht mitgezhlt */
SELECT 
		type.id, 
		type.fullName,
		count(distinct func.id)
FROM 
		TTypes as type join 
		TModelElements mType on (type.id = mType.id) join
		TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
		TModelElements as elem on (type.id = elem.parentId) join 
		TFunctions as func on (elem.parentid = func.classId) join 
		TConstants as con on (elem.kindofelement = con.value) join
		TMembers as member on (member.id = func.id) join
		TConstants as constants on (member.visibility = constants.value)
WHERE 
		elem.id = func.id and 
		(con.name like 'FUNC_METHOD') AND
		member.isstatic = 0 AND
		member.isfinal = 0  AND
		constants.name != 'VISIBILITY_PRIVATE' 
GROUP BY	
		type.id,
		type.fullName
	
;


CREATE TABLE VMethodsInherited(
	TypeId INTEGER,
	TypeName VARCHAR(1024),
	numberOfInheritedMethods INTEGER)
;

INSERT INTO VMethodsInherited (TypeId, TypeName, numberOfInheritedMethods)
SELECT
	type.id,
	type.fullName,
	SUM (mpc.numberOfMethods)
FROM
	TTypes as type join
	TModelElements mType on (type.id = mType.id) join
	TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
	TInheritances as inheritance on (type.id = inheritance.classid) join
	VMethodsPerClass as mpc on (mpc.TypeId = inheritance.superid)
GROUP BY
	type.id,
	type.fullName

;

CREATE TABLE VOverridesPerClass(
	TypeId INTEGER,
	TypeName VARCHAR(1024),
	numberOfOverrides INTEGER)
;

INSERT INTO VOverridesPerClass (TypeId, TypeName, numberOfOverrides)
/* Wie viele Methoden der Klasse berschreiben eine Methode der Oberklasse */
SELECT 
		type.id, 
		type.fullName, 
		count(distinct methodOverrides.OverrideMethodId)
FROM 
		TTypes as type join 
		TModelElements mType on (type.id = mType.id) join
		TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
		VMethodOverrides as methodOverrides on (type.id = methodOverrides.SubClassId)
GROUP BY	
		type.id,
		type.fullName
	

;

/*

Problemmuster gendert, nur noch Teil 2 der Erkennung relevant
Dieser Teil ist nun Generationskonflikt

SELECT
	mi.TypeName as ClassName,
	mi.numberOfInheritedMethods * 1.0 as NumberOfInheritedMethods,
	opc.numberOfOverrides * 1.0 as NumberOfOverrides,
	(opc.numberOfOverrides*1.0) / (mi.numberOfInheritedMethods*1.0) as Ratio,
	files.pathname
	
FROM
	VMethodsInherited as mi join
	VOverridesPerClass as opc on (mi.TypeId = opc.TypeId) join
	TSourceEntities se on (mi.TypeId = se.id) join
	TFiles files on (se.sourcefileid = files.id)

WHERE
	(opc.numberOfOverrides*1.0) / (mi.numberOfInheritedMethods*1.0) > 0.66	

	
;

*/

/* Teil 2: Eine Methode wird in mehr als 66% der direkten und indirekten Unterklassen berschrieben */

CREATE TABLE VNumberOfSubClasses(
	superid INTEGER,
	numberOfSubclasses INTEGER)
;

INSERT INTO VNumberOfSubClasses (superid, numberOfSubclasses)
SELECT
	ti.superid,
	count(distinct ti.classid) as numberOfSubclasses
	
FROM
	TInheritances as ti
GROUP BY 
	ti.superid

;

CREATE TABLE VNumberOfOverrides(
	OverridenMethodID INTEGER,
	OverridenMethodName VARCHAR(256),
	SuperClassId INTEGER,
	SuperClassFullName VARCHAR(1024),
	NumberOfOverrides INTEGER)
;

INSERT INTO VNumberOfOverrides (OverridenMethodId, OverridenMethodName, SuperClassId, SuperClassFullName, NumberOfOverrides)
SELECT
	mo.OverridenMethodID,
	mo.OverridenMethodName,
	mo.SuperClassId,
	mo.SuperClassFullName,
	count(DISTINCT mo.OverrideMethodId)
FROM
	VMethodOverrides as mo
GROUP BY 
	mo.OverridenMethodID,
	mo.OverridenMethodName,
	mo.SuperClassId,
	mo.SuperClassFullName
;

/* The number of subclasses indicates the maximum number of 
potential overrides, so that is our threshold */

SELECT
        noo.SuperClassFullName as superclass_full_name,
        sig.signature as overriddenmethod_signature,
	files.pathname as file_name,
        src_method.startline as line_number,
	noo.NumberOfOverrides as number_of_overrides,
	nosc.NumberOfSubClasses as number_of_subclasses,
	(noo.NumberOfOverrides*1.0) / (nosc.NumberOfSubClasses*1.0) as number_of_overrides_per_number_of_subclasses
FROM
	VNumberOfOverrides as noo join
	VNumberOfSubClasses as nosc on (noo.superClassId = nosc.superid) join
	TSourceEntities se on (noo.SuperClassId = se.id) join
	TFiles files on (se.sourcefileid = files.id) join
        TSignatures sig on (sig.functionid = noo.OverridenMethodID) left outer join
        TSourceEntities src_method on (src_method.id = noo.OverridenMethodID)
WHERE
	(noo.NumberOfOverrides*1.0) / (nosc.NumberOfSubClasses*1.0) > 0.50
;


DROP Table VMethodsInherited;
DROP Table VNumberOfOverrides;
DROP Table VNumberOfSubClasses;
DROP Table VOverridesPerClass;
DROP Table VMethodsPerClass;
DROP Table VMethodOverrides;
