/* $Id: PolymorphismPlacebo.sql,v 1.1 2010/04/19 16:31:52 stammel Exp $ */
/* FZI Forschungszentrum Informatik */



SELECT DISTINCT 
        pA.fullname AS superclass_package_full_name,
	A.fullName AS superclass_full_name, 
	SA.signature AS supermethod_signature, 
        fA.pathname AS supermethod_file_name,
        srcA.startline AS supermethod_line_number,
        
        pB.fullname AS subclass_package_full_name,
	B.fullName AS subclass_full_name, 
	SB.signature AS pseudo_override_method_signature,
        fB.pathname AS pseudo_override_method_file_name,
        srcB.startline AS pseudo_override_method_line_number
FROM 
	TTypes AS A join 
	TModelElements AS mA on (A.id = mA.id) join
	TConstants cmA on (mA.status = cmA.value AND cmA.name = 'STATUS_NORMAL') join
	TInheritances AS tInheritanceAB on (tInheritanceAB.superId = A.id) join
	TTypes AS B on (tInheritanceAB.classId = B.id) join  
	TModelElements AS mB on (mB.id = B.id) join
	TConstants AS cmB on (mB.status = cmB.value AND cmB.name = 'STATUS_NORMAL') join
	TMembers AS memberAm_A on (memberAm_A.classId = A.id AND memberAm_A.isstatic = 1) join
	TFunctions AS Am on (Am.id = memberAm_A.id) join
	TMembers AS memberBm_B on (memberBm_B.classId = B.id) join
	TFunctions AS Bm on (Bm.id = memberBm_B.id) join
	TConstants AS con on (memberAm_A.visibility != con.value AND con.name = 'VISIBILITY_PRIVATE') join
	TSignatures AS SA on (SA.functionId = Am.id) join
	TSignatures AS SB on (SB.functionId = Bm.id AND SA.signature = SB.signature) join
        TPackages AS pA on (pA.id = A.packageid) join
        TPackages AS pB on (pB.id = B.packageid) join
        TSourceEntities AS srcA on (srcA.id = Am.id) join
	TFiles AS fA on (fA.id = srcA.sourcefileid) join	
        TSourceEntities AS srcB on (srcB.id = Bm.id) join
        TFiles AS fB on (fB.id = srcB.sourcefileid)
;


