/* $Id: ObjectPlaceboAttribute.sql,v 1.1 2010/04/19 16:31:52 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


SELECT
	pack.fullName as source_package_full_name,
	types2.fullName as source_class_full_name,
	sig2.signature as source_function_signature,
        source_file.pathname as source_file_name,
        source_src.startline as source_line_number,

        target_pack.fullname as target_package_full_name,
	types1.fullName as target_class_name,
	fld.name as target_field_name,
        target_file.pathname as target_file_name,
        target_src.startline as target_line_number
FROM
	TAccesses accesses1 join
	TMembers members on (members.id = accesses1.targetid and 
		members.isstatic = 1 ) join
	TTypes tt on tt.id = accesses1.classId join
	TModelElements mTT on (mTT.id = tt.id) join
	TConstants cmTT on (cmTT.value = mTT.status and cmTT.name = 'STATUS_NORMAL') join
	TVariables fld on members.id = fld.id join
	TAccesses accesses2 on (accesses1.sourceid = accesses2.sourceid and
		accesses2.position = accesses1.position - 1) join
	TConstants constants2 on (accesses2.kindofaccess = constants2.value and
		constants2.name != 'TYPEACCESS_STATIC') join
	TTypes types1 on members.classId = types1.id left outer join
	TTypes types2 on accesses1.classId = types2.id left outer join
	TSignatures sig2 on accesses1.functionId = sig2.functionId left outer join
	TFunctions f on sig2.functionid = f.id left outer join
	TPackages pack on f.packageId = pack.id left outer join
	TMembers srcMemb on f.id = srcMemb.id left outer join

        TSourceEntities source_src on source_src.id = f.id left outer join
        TFiles source_file on source_file.id = source_src.sourcefileid left outer join

        TPackages target_pack on (target_pack.id = tt.packageid) left outer join
        TSourceEntities target_src on target_src.id = fld.id left outer join
        TFiles target_file on target_file.id = target_src.sourcefileid
WHERE
	constants2.name not like 'SELFACCESS_%' or
	(constants2.name like 'SELFACCESS_%' and
		srcMemb.isStatic = 0)	

;
