/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT DISTINCT
	sub.fullname as abstract_subclass_name,
	super.fullname as non_abstract_superclass_name,
	fSub.pathname as subclass_file_name,
	seSub.startline as subclass_line_number,
	fSuper.pathname as superclass_file_name,
	seSuper.startline as superclass_line_number
FROM
	TInheritances inh 
	join TTypes sub on inh.classId=sub.id
	join TTypes super on inh.superId=super.id
	join TModelElements mSub on sub.id = mSub.id
	join TModelElements mSuper on super.id = mSuper.id
	join TConstants cmSub on mSub.status = cmSub.value
	join TConstants cmSuper on mSuper.status = cmSuper.value
	join TSourceEntities seSub on seSub.id = sub.id 
	join TSourceEntities seSuper on seSuper.id = super.id
	join TFiles fSub on seSub.sourceFileId = fSub.id 
	join TFiles fSuper on seSuper.sourceFileId = fSuper.id
	join TMembers memSub on memSub.id = sub.id
	join TMembers memSuper on memSuper.id = super.id 
	join TConstants constTypeClass on super.kindOfType = constTypeClass.value
WHERE
	cmSub.name = 'STATUS_NORMAL'
	AND cmSuper.name = 'STATUS_NORMAL'
	/* all system defined classes that are related */
	AND constTypeClass.name = 'TYPE_CLASS' and
	/* avoid interfaces and others */
	memSub.isabstract = 1 and
	memSuper.isabstract = 0
;
