/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE VIEW VMethodsWithoutFormalComment as

SELECT
	func.id,
	func.name,
	func.classid
FROM
	TFunctions func join
	TModelelements mFunction on (func.id = mFunction.id) join
	TConstants cmFunction on (cmFunction.value = mFunction.status and cmFunction.name = 'STATUS_NORMAL') join
	TMembers member on (func.id = member.id) join
	TConstants con on (member.visibility = con.value) 
WHERE
	con.name = 'VISIBILITY_PUBLIC'

EXCEPT

SELECT
	func.id,
	func.name,
	func.classid
FROM
	TFunctions func join
	TAnnotations annotation on (func.id = annotation.modelelementid) join
	TComments comments on (annotation.annotationid = comments.id) join
	TSourceEntities functionSE on (func.id = functionSE.id) join
	TSourceEntities commentSE on (commentSE.id = comments.id)
WHERE
	comments.isformal > 0 AND
	/* Heuristik: Formaler Kommentar muss vor der Methode stehen */
	/* Siehe Suns Seiten zu JavaDoc: A doc comment is written in HTML and must precede a class, field, constructor or method declaration */
	commentSE.startline < functionSE.startline 
;

SELECT
	type.fullname as class_name,
	sig.signature as method_signature,
	file.pathname AS file_name,
	sourceentity.startline as line_number
FROM
	VMethodsWithoutFormalComment vmwfc join
	TTypes type on (vmwfc.classid = type.id) join
	TSignatures sig on vmwfc.id = sig.functionid left outer join
	TSourceEntities sourceentity on (vmwfc.id = sourceentity.id) left outer join
	TFiles file on (sourceentity.sourcefileid = file.id)
	
;

DROP VIEW VMethodsWithoutFormalComment;
