/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

select distinct
	res.SourceFileName as file_name,
	res.KindOfTarget as kind_of_element,
	res.TargetName as element_name,
	res.ImportCount as number_of_imports
from
	(
	select 
		f.id as SourceFileId,
		f.pathName as SourceFileName,
		con.name as KindOfTarget,
		target.id as TargetId,
		target.pathName as TargetName,
		count (*) as ImportCount
	from
		TFiles f,
		TModelElements mF,
		TConstants cmF,
		TImports imp,
		TConstants con,
		TFiles target
	where
		f.id = mF.id
		AND cmF.value = mF.status
		AND cmF.name = 'STATUS_NORMAL'
		AND imp.fileId = f.id and
		imp.kindOfTarget = con.value and
		target.id = imp.targetId
	group by
		f.id,
		f.pathName,
		con.name,
		target.id,
		target.pathName
	
	union
	
	select 
		f.id as SourceFileId,
		f.pathName as SourceFileName,
		con.name as KindOfTarget,
		target.id as TargetId,
		target.fullName as TargetName,
		count (*) as ImportCount	
	from
		TFiles f,
		TModelElements mF,
		TConstants cmF,
		TImports imp,
		TConstants con,
		TPackages target
	
	where
		f.id = mF.id
		AND cmF.value = mF.status
		AND cmF.name = 'STATUS_NORMAL'
		AND imp.fileId = f.id and
		imp.kindOfTarget = con.value and
		target.id = imp.targetId
	group by
		f.id,
		f.pathName,
		con.name,
		target.id,
		target.fullName
	
	union
	
	select 
		f.id as SourceFileId,
		f.pathName as SourceFileName,
		con.name as KindOfTarget,
		target.id as TargetId,
		target.fullName as TargetName,
		count (*) as ImportCount
	from
		TFiles f,
		TModelElements mF,
		TConstants cmF,
		TImports imp,
		TConstants con,
		TTypes target
	where
		f.id = mF.id
		AND cmF.value = mF.status
		AND cmF.name = 'STATUS_NORMAL'
		AND imp.fileId = f.id and
		imp.kindOfTarget = con.value and
		target.id = imp.targetId
	group by
		f.id,
		f.pathName,
		con.name,
		target.id,
		target.fullName
	
	union
	
	select 
		f.id as SourceFileId,
		f.pathName as SourceFileName,
		con.name as KindOfTarget,
		target.id as TargetId,
		pack.fullName || '.' || target.name as TargetName,
		count (*) as ImportCount
	from
		TFiles f,
		TModelElements mF,
		TConstants cmF,
		TImports imp,
		TConstants con,
		TPackages pack,
		TVariables target
	where
		f.id = mF.id
		AND cmF.value = mF.status
		AND cmF.name = 'STATUS_NORMAL'
		AND imp.fileId = f.id and
		imp.kindOfTarget = con.value and
		target.id = imp.targetId and
		target.packageId = pack.id
	group by
		f.id,
		f.pathName,
		con.name,
		target.id,
		pack.fullName || '.' || target.name
	
	union
	
	select 
		f.id as SourceFileId,
		f.pathName as SourceFileName,
		con.name as KindOfTarget,
		target.id as TargetId,
		pack.fullName || '.' || sig.signature as TargetName,
		count (*) as ImportCount
	from
		TFiles f,
		TModelElements mF,
		TConstants cmF,
		TImports imp,
		TConstants con,
		TPackages pack,
		TFunctions target,
		TSignatures sig
	where
		f.id = mF.id
		AND cmF.value = mF.status
		AND cmF.name = 'STATUS_NORMAL'
		AND imp.fileId = f.id and
		imp.kindOfTarget = con.value and
		target.id = imp.targetId and
		target.packageId = pack.id and
		target.id = sig.functionId and
		con.name != 'FUNC_TYPE_DELEGATE'
	group by
		f.id,
		f.pathName,
		con.name,
		target.id,
		pack.fullName || '.' || sig.signature
	) as res
where 
	res.ImportCount > 1 or
	res.KindOfTarget LIKE 'PACK_%' or
	res.TargetName LIKE 'java.lang%'

UNION

/* Imports aus eigenem Paket */

select 
	f.pathname as file_name,
	'TYPE_CLASS' as kind_of_element,
	type2.fullname as element_name,
	count(*) as number_of_imports
from
	TFiles f join
	TModelElements mF on (mF.id = f.id) join
	TConstants cmF on (cmF.value = mF.status and cmF.name = 'STATUS_NORMAL') join
	TSourceEntities s on (s.sourcefileid = f.id) join
	TTypes type on (s.id = type.id) join
	TTypes type2 on (type.packageid = type2.packageid and type.id <> type2.id) join
	TImports imp on (imp.fileid = f.id and imp.targetid = type2.id)
group by
	f.pathname,
	kind_of_element,
	type2.fullname
;

