/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE TABLE TNumberOfClassesPerSubsystemAbstraction (subsystem_name varchar(256), number_of_public_classes int);

INSERT INTO TNumberOfClassesPerSubsystemAbstraction 
SELECT DISTINCT
	abstraction.name as subsystem_name,
	COUNT(type.id) as number_of_public_classes
FROM
	TAbstractions abstraction
	join TAbstractionElements abstractionElement on abstraction.id = abstractionElement.abstractionid
	join TFiles file on file.id = abstractionElement.modelelementid
	join TSourceEntities sourceEntity on sourceEntity.sourcefileid = file.id
	join TTypes type on type.id = sourceEntity.id
	join TMembers typeMember on typeMember.id = type.id
	join TConstants typeVisibility on  typeVisibility.value = typeMember.visibility
WHERE	
	abstraction.type = 'Subsystem'
	AND typeVisibility.name = 'VISIBILITY_PUBLIC'
	AND type.classid = -1
GROUP BY
	abstraction.name
;

SELECT
	*
FROM
	TNumberOfClassesPerSubsystemAbstraction nocpsa
WHERE
	nocpsa.number_of_public_classes > 50

;

DROP Table TNumberOfClassesPerSubsystemAbstraction;
