/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE View VPublicAttributesPerClass AS

SELECT
	types.fullname as god_class_name,
	COUNT (variables.id) as number_of_attributes,
	files.pathname as file_name,
	sourceEntities.startLine as line_number
FROM 
	TTypes types join
	TModelElements mA on (types.id = mA.id) join
	TConstants cmA on (cmA.value = mA.status and cmA.name = 'STATUS_NORMAL') join	
	TVariables variables on (variables.classid = types.id) join
	TConstants cons on (variables.kindofvariable = cons.value) join
	TMembers members on (variables.id = members.id) join
	TConstants cons2 on (cons2.value = members.visibility) join
	TSourceEntities sourceEntities on (types.id = sourceEntities.id) join
	TFiles files on (sourceEntities.sourcefileid = files.id) 
WHERE
	cons.name = 'VAR_FIELD'  AND
	variables.name <> '<self>' AND
	NOT (members.isstatic = 1 AND
		members.isfinal = 1) 
GROUP BY
	types.fullname,
	files.pathname,
	sourceEntities.startLine

;

SELECT 
	*
FROM
	VPublicAttributesPerClass papc
WHERE
	papc.number_of_attributes > 50

;



DROP View VPublicAttributesPerClass;
