/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

create table VMethodOverrides (SubClassId int, SubClassFullName varchar(256), OverrideMethodId int, OverrideMethodName varchar(256), SuperClassId int, SuperClassFullName varchar(256), OverridenMethodId int, OverridenMethodName varchar(256) );

insert into VMethodOverrides 
SELECT
	A.id as SubClassId,
	A.fullname as SubClassFullName,
	FA.id as OverrideMethodId,
	FA.name as OverrideMethodName,
	B.id as SuperClassId,
	B.fullname as SuperClassFullName,
	FB.id as OverridenMethodId,
	FB.name as OverridenMethodName
FROM
	TTypes A
	join TMembers A_Am on A.id = A_Am.classID
	join TMembers B_Bm on A_Am.overridenmemberid = B_Bm.id
	join TModelElements mA on A.id = mA.id
	join TTypes B on B.id = B_Bm.classID
	join TFunctions FA on FA.id = A_Am.id
	join TFunctions FB on FB.id = B_Bm.id
	join TConstants visibility on B_Bm.visibility = visibility.value
	join TModelElements mB on B.id = mB.id
	join TConstants cmA on cmA.value = mA.status
	join TConstants cmB on cmB.value = mB.status
WHERE 
	cma.name = 'STATUS_NORMAL'
	AND cmB.name = 'STATUS_NORMAL' 
	AND
	/* Die Methoden drfen nicht "leer" sein */
	FA.NumberOfStatements > 0 AND
	FB.NumberOfStatements > 0 
	/* Die Methode ist public/protected */
	 AND 
	(
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR
	
		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)
	)/*AND*/

EXCEPT

SELECT
	A.id as SubClassId,
	A.fullname as SubClassFullName,
	FA.id as OverrideMethodId,
	FA.name as OverrideMethodName,
	B.id as SuperClassId,
	B.fullname as SuperClassFullName,
	FB.id as OverridenMethodId,
	FB.name as OverridenMethodName
FROM
	TTypes A 
	join TMembers A_Am on A.id = A_Am.classID	
	join TMembers B_Bm on A_Am.overridenmemberid = B_Bm.id
	join TModelElements mA on A.id = mA.id
	join TConstants cmA on cmA.value = mA.status
	join TFunctions FA on FA.id = A_Am.id
	join TTypes B on B.id = B_Bm.classID
	join TModelElements mB on B.id = mB.id
	join TConstants cmB on cmB.value = mB.status
	join TFunctions FB on FB.id = B_Bm.id
	join TConstants visibility on B_Bm.visibility = visibility.value
	join TAccesses accesses on (accesses.targetid = FB.id AND accesses.functionid = FA.id)
WHERE 
	cma.name = 'STATUS_NORMAL'
	AND cmB.name = 'STATUS_NORMAL' 
	/* Die Methode ist public/protected */
	 AND 
	(
		(visibility.name = 'VISIBILITY_PUBLIC' OR 
			visibility.name = 'VISIBILITY_PROTECTED') OR
		/* Oder die Methode ist package-local deklariert und A ist in dem selben Paket wie parent */ 
		(visibility.name = 'VISIBILITY_PACKAGE' AND 
			A.packageId = B.packageId)			
	)/*AND*/ 

	/* Die Methode der Unterklasse ruft die Methode der Oberklasse auf, ergnzt sie sozusagen */
;
/* Die Method A_m ist fast leer 
	FA.NumberOfStatements > 0 AND
	FB.NumberOfStatements > 0 AND
		*/


/* Wie viele Methoden haben die Klassen, die vererbt werden, Konstruktoren und Desktruktoren werden nicht mitgezhlt */

create table VMethodsPerClass (TypeId int, TypeName varchar(256), numberOfMethods int);

insert into VMethodsPerClass 
SELECT 
		type.id as TypeId, 
		type.fullName as TypeName,
		count(distinct func.id) as numberOfMethods
FROM 
		TTypes as type join 
		TModelElements as mType on (mType.id = type.id) join
		TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
		TModelElements as elem on (type.id = elem.parentId) join 
		TFunctions as func on (elem.parentid = func.classId) join 
		TConstants as con on (elem.kindofelement = con.value) join
		TMembers as member on (member.id = func.id) join
		TConstants as constants on (member.visibility = constants.value)
WHERE 
		elem.id = func.id and 
		(con.name like 'FUNC_METHOD') AND
		member.isstatic = 0 AND
		member.isfinal = 0  AND
		constants.name != 'VISIBILITY_PRIVATE' 
GROUP BY	
		type.id,
		type.fullName
	
;



create table VMethodsInherited (TypeId int, TypeName varchar(256), numberOfInheritedMethods int);

insert into VMethodsInherited 
SELECT
	type.id as TypeId,
	type.fullName as TypeName,
	SUM (mpc.numberOfMethods) as numberOfInheritedMethods
FROM
	TTypes as type join
	TInheritances as inheritance on (type.id = inheritance.classid) join
	VMethodsPerClass as mpc on (mpc.TypeId = inheritance.superid)
GROUP BY
	type.id,
	type.fullName

;

/* Wie viele Methoden der Klasse berschreiben eine Methode der Oberklasse */

create table VOverridesPerClass (TypeId int, TypeName varchar(256), numberOfOverrides int);

insert into VOverridesPerClass 
SELECT 
		type.id as TypeId, 
		type.fullName as TypeName, 
		count(distinct methodOverrides.OverrideMethodId) as numberOfOverrides
FROM 
		TTypes as type join 
		TModelElements as mType on (mType.id = type.id) join
		TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
		VMethodOverrides as methodOverrides on (type.id = methodOverrides.SubClassId)
GROUP BY	
		type.id,
		type.fullName
	

;


/*

Eine Methode reimplementiert mehr als 50 % der Methoden einer Oberklasse,
ohne diese aufzurufen

*/

SELECT
	mi.TypeName as class_name,
	mi.numberOfInheritedMethods * 1.0 as number_of_inherited_methods,
	opc.numberOfOverrides * 1.0 as number_of_overridden_methods,
	(opc.numberOfOverrides*1.0) / (mi.numberOfInheritedMethods*1.0) as ratio,
	files.pathname as file_name,
	se.startLine as line_number
FROM
	VMethodsInherited as mi join
	VOverridesPerClass as opc on (mi.TypeId = opc.TypeId) left outer join
	TSourceEntities se on (mi.TypeId = se.id) left outer join
	TFiles files on (se.sourcefileid = files.id)

WHERE
	(opc.numberOfOverrides*1.0) / (mi.numberOfInheritedMethods*1.0) > 0.5
;



DROP Table VMethodsInherited;
DROP Table VOverridesPerClass;
DROP Table VMethodsPerClass;
DROP Table VMethodOverrides;
