/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT
	P.fullName as package_name,
	C.fullName as class_name,
	sig.signature as function_signature,
	func.numberOfEdges - func.numberOfNodes + 1 as cyclomatic_complexity,
	files.pathname as file_name,
	srcEnt.startLine as line_number	
FROM
	TFunctions func INNER JOIN
	TModelElements meFunc on (meFunc.id = func.id) INNER JOIN
	TConstants cmeFunc on (cmeFunc.value = meFunc.status and cmeFunc.name = 'STATUS_NORMAL') INNER JOIN
	TSignatures sig on func.id = sig.functionId LEFT OUTER JOIN
	TTypes C on func.classId = C.id LEFT OUTER JOIN
	TPackages P on (C.PackageId = P.id OR func.packageId = P.id) left outer join
	TSourceEntities srcEnt on (func.id = srcEnt.id) left outer join
	TFiles files on (srcEnt.sourceFileId = files.id)
WHERE
	func.numberOfEdges - func.numberOfNodes + 1 > 10 /* SCHWELLWERT */
ORDER BY
	cyclomatic_complexity DESC
;
