/* $Id: UnvollstaendigeVererbungMethode.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */
/* FZI Forschungszentrum Informatik */



create or replace view VMethodsInSubClasses as

select 
	func.name as functionname,
	sig.signature as signature,
	supertype.id as supertypeid,
	supertype.name as supertypename,
        supertype.fullname as supertype_full_name,
	count (supertype.id)
from
	TFunctions func join
	TModelElements m on (func.id = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join	
	TConstants con on (func.kindoffunction = con.value) join
	TSignatures sig on (sig.functionid = func.id) join
	TTypes type on ( func.classid = type.id) join
	TInheritances inh on (inh.classid = type.id) join
	TTypes supertype on (inh.superid = supertype.id) join
	TSourceEntities source on (source.id = supertype.id) join
	TFiles file on (source.sourcefileid = file.id)
where
	con.name = 'FUNC_METHOD' and
	inh.depthofinheritance = 1 and
	
	not exists (
		select
			*
		from
			TSignatures sig2 join
			TFunctions func2 on (sig2.functionid = func2.id) join
			TInheritances inh2 on (inh2.classid = supertype.id) join
			TInheritances inh3 on (inh3.classid = type.id)
		where
			sig2.signature = sig.signature and
			(func2.classid = supertype.id or
			 func2.classid = inh2.superid or
			 func2.classid = inh3.superid)
	)

			
group by
	func.name,
	sig.signature,
	supertype.id,
	supertype.name,
        supertype.fullname

;


create or replace view VNumberOfSubclasses as
select 
	type.id,
	type.name,
	count (inh.classid)
from
	TTypes type join
	TInheritances inh on (inh.superid = type.id)
where
	inh.depthofinheritance = 1
group by
	type.id,
	type.name
;

select 
        package_superclass.fullname AS package__full_name,
        misc.supertype_full_name AS superclass_full_name,
        file_superclass.pathname AS superclass_file_name,
	misc.signature AS method_in_subclass_signature,
	misc.count as number_of_sibling_methods,
        nosc.count AS number_of_subclasses
from
	VMethodsInSubClasses misc join
	VNumberOfSubclasses nosc on (misc.supertypeid = nosc.id) join
        TTypes type_superclass on (type_superclass.id = misc.supertypeid) join
        TPackages package_superclass on (package_superclass.id = type_superclass.packageid) left outer join

        TSourceEntities src_superclass on (src_superclass.id = type_superclass.id) left outer join
        TFiles file_superclass on (file_superclass.id = src_superclass.sourcefileid)
where
	misc.count > 1 and (
	misc.count >= 10 or 
	((misc.count * 1.0) / (nosc.count * 1.0) > 0.5))
;




drop view VNumberOfSubclasses;
drop view VMethodsInSubClasses;
