CREATE TABLE TNumberOfClassesPerSubsystemAbstraction AS

SELECT DISTINCT
        abstraction.id,
	abstraction.name,
	COUNT(type.id) as number_of_public_classes
FROM
	TAbstractions abstraction,
	TAbstractionElements abstractionElement,
	TFiles file,
	TSourceEntities sourceEntity,
	TTypes type,
	TMembers typeMember,
	TConstants typeVisibility
WHERE	
	abstraction.id = abstractionElement.abstractionid 
	AND abstraction.type = 'Subsystem'
	AND file.id = abstractionElement.modelelementid
	AND sourceEntity.sourcefileid = file.id
	AND type.id = sourceEntity.id
	AND typeMember.id = type.id
	AND typeVisibility.value = typeMember.visibility
	AND typeVisibility.name = 'VISIBILITY_PUBLIC'
	AND type.classid = -1
GROUP BY
	abstraction.id,
	abstraction.name
;


SELECT
	nocpsa.name as package_name,
        nocpsa.number_of_public_classes as number_of_public_classes
FROM
	TNumberOfClassesPerSubsystemAbstraction nocpsa
WHERE
	nocpsa.number_of_public_classes > 0
	AND nocpsa.number_of_public_classes < 3
;

DROP Table TNumberOfClassesPerSubsystemAbstraction;
	
	
	