/* $Id: ObjektplaceboMethode.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


SELECT
	pack.fullName as source_package_full_name,
	types2.fullName as source_slass_full_name,
	sig2.signature as source_function_signature,
        source_file.pathname as source_file_name,
        source_src.startline as source_line_number,

        target_pack.fullname as target_package_full_name,
	types1.fullName as target_class_name,
	sig.signature as target_method_signature,
	accesses2.position as position,
        target_file.pathname as target_file_name,
        target_src.startline as target_line_number
FROM
	TAccesses accesses1 join
	TMembers members on (members.id = accesses1.targetid and 
		members.isstatic = 1 ) join 
	TConstants con1 on (members.kindofmember = con1.value and
		con1.name = 'FUNC_METHOD') join
	TTypes tt on tt.id = accesses1.classId join
	TModelElements mTT on (mTT.id = tt.id) join
	TConstants cmTT on (cmTT.value = mTT.status and cmTT.name = 'STATUS_NORMAL') join
	TSignatures sig on members.id = sig.functionId join
	TAccesses accesses2 on (accesses1.sourceid = accesses2.sourceid and
		accesses2.position = accesses1.position - 1) join
	TConstants constants2 on (accesses2.kindofaccess = constants2.value and
		constants2.name != 'TYPEACCESS_STATIC') join
	TTypes types1 on members.classId = types1.id left outer join
	TTypes types2 on accesses1.classId = types2.id left outer join
	TSignatures sig2 on accesses1.functionId = sig2.functionId left outer join
	TFunctions f on sig2.functionid = f.id left outer join
	TPackages pack on f.packageId = pack.id left outer join
	TMembers srcMemb on f.id = srcMemb.id left outer join

        TSourceEntities source_src on source_src.id = f.id left outer join
        TFiles source_file on source_file.id = source_src.sourcefileid left outer join

        TFunctions target_f on sig.functionid = target_f.id left outer join
        TPackages target_pack on f.packageid = target_pack.id left outer join
        TSourceEntities target_src on (target_src.id = target_f.id) left outer join
        TFiles target_file on (target_src.sourcefileid = target_file.id)
WHERE
	constants2.name not like 'SELFACCESS_%' or
	(constants2.name like 'SELFACCESS_%' and
		srcMemb.isStatic = 0)	
;
