/* $Id: Gottpaket.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */
/* FZI Forschungszentrum Informatik */

create or replace view VPackElements as
SELECT 
	pack.id as PackageId, 
	pack.fullName as PackageName,
	elem.id as ElemId
FROM
	TPackages as pack join
	TTypes as elem on (pack.id = elem.packageId) join
	TModelElements mA on (elem.id = mA.id) join
	TConstants cmA on (cmA.value = mA.status and cmA.name = 'STATUS_NORMAL') join	
	TMembers as member on (elem.id = member.id) join
	TConstants as con on (member.visibility = con.value) join
	TSourceEntities as se on (elem.id = se.id) 
WHERE
	se.sourcefileid <> '-1' AND
	elem.classid = '-1' /* no inner classes*/ AND
	con.name = 'VISIBILITY_PUBLIC' 
;


/* Count directly contained model elements */
SELECT
	res.PackageName as package_name, 
	count(distinct res.ElemId) as number_of_public_classes
FROM
	VPackElements as res
GROUP BY
	res.PackageName
HAVING 
	count(distinct res.ElemId) > 50
ORDER BY
	number_of_public_classes
;	


drop view VPackElements;
