/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence.config;

import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.persistence.config.FileBasedDatabaseConfiguration;

public class SqliteDatabaseConfiguration
extends DatabaseConfiguration
implements FileBasedDatabaseConfiguration {
    private String sqliteDirectoryPath;

    @Override
    public String getDatabaseDriver() {
        return "org.sqlite.JDBC";
    }

    @Override
    public String getDatabaseEmptyscriptFile() {
        return "/res/sql/empty.sqlitesql";
    }

    @Override
    public String getDatabaseInitscriptFile() {
        return "/res/sql/init.sqlitesql";
    }

    @Override
    public String getDatabaseURL() {
        return "jdbc:sqlite:" + this.getDirectoryPath() + "/" + this.getDatabaseName();
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = String.valueOf(result) + "Sqlite Directory:    " + this.nullSafeToString(this.getDirectoryPath()) + "\n";
        return result;
    }

    @Override
    public String getDirectoryPath() {
        return this.sqliteDirectoryPath.replace('\\', '/');
    }

    @Override
    public void setDirectoryPath(String sqliteDirectoryPath) {
        this.sqliteDirectoryPath = sqliteDirectoryPath;
    }

    @Override
    public String getDatabaseURL(String serverUrl) {
        return this.getDatabaseURL();
    }

    @Override
    public String formatSQLStatement(String sqlstm) {
        String result = sqlstm.replaceAll(";", "");
        return result;
    }

    @Override
    public String getErrorMessage() {
        String superMsg = super.getErrorMessage();
        if (!superMsg.equals("")) {
            return superMsg;
        }
        StringBuilder result = new StringBuilder();
        if (this.sqliteDirectoryPath == null) {
            result.append("Database path not set\n");
        }
        return result.toString();
    }
}

